package gov.va.med.esr.xml.mapping.castor;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.exolab.castor.mapping.GeneralizedFieldHandler;

public class DateHandler extends GeneralizedFieldHandler {
	public static final String YYYY_MM_DD_FORMAT = "yyyy-MM-dd";
	protected String FORMAT = YYYY_MM_DD_FORMAT;
	
	public DateHandler() {
		super();
	}
	
	@Override
	public Object convertUponGet(Object value) {
		if(value == null) return null;
		SimpleDateFormat formatter = new SimpleDateFormat(FORMAT);
		Date date = (Date) value;
		return formatter.format(date);
	}
	@Override
	public Object convertUponSet(Object value) {
		SimpleDateFormat formatter = new SimpleDateFormat(FORMAT);
		Date date = null;
		try {
			date = formatter.parse((String)value);
		} catch (java.text.ParseException e) {
			throw new IllegalArgumentException(e.getMessage());
		}
		return date;
	}
	@Override
	public Class<Date> getFieldType() {
		return Date.class;
	}
}
