package gov.va.med.esr.webservices.jaxws.spring.security;

import javax.crypto.SecretKey;

/**
 * Default implentation of KeyManager.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class KeyManagerImpl implements KeyManager
{
	/**
	 * Gets the secret key.
	 */
	public SecretKey getKey(KeyCache keyCache)
	{
		if(keyCache != null)
		{
			return keyCache.getKey();
		}
		return null;
	}
	
	/**
	 * Sets the secret key. 
	 */
	public void setKey(KeyCache keyCache, SecretKey secretKey)
	{
		if(keyCache != null && secretKey != null)
		{
				keyCache.setKey(secretKey);
		}
	}
}
