package gov.va.med.esr.webservices.jaxws.spring.interceptor;

import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.EndpointInterceptor;

public class MessageContextHolderInterceptor implements EndpointInterceptor {
	public boolean handleRequest(MessageContext messageContext, Object endpoint)
			throws Exception {
		MessageContextHolder.setMessageContext(messageContext);
		return true;
	}

	public boolean handleResponse(MessageContext messageContext, Object endpoint)
			throws Exception {
		MessageContextHolder.removeMessageContext();
		return true;
	}

	public boolean handleFault(MessageContext messageContext, Object endpoint)
			throws Exception {
		
		MessageContextHolder.removeMessageContext();
		return true;
	}
}
