package gov.va.med.esr.webservices.jaxws.spring.interceptor;

import gov.va.med.esr.model.ServiceLog;
import gov.va.med.esr.model.ServiceUser;

import java.util.Iterator;

import javax.xml.transform.dom.DOMSource;

import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.saaj.SaajSoapMessage;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MessageContextHolder {


	
	private static ThreadLocal<MessageContext> threadLocal = new ThreadLocal<MessageContext>() {
		@Override
		protected MessageContext initialValue() {
			return null;
		}
	};

	private MessageContextHolder() {
	}

	public static MessageContext getMessageContext() {
		return threadLocal.get();
	}

	public static void setMessageContext(MessageContext context) {
		threadLocal.set(context);

		
		SaajSoapMessage request = (SaajSoapMessage) context.getRequest();
		
		
		Iterator it = request.getSoapHeader().examineAllHeaderElements();
		String userName = null;
		while (it.hasNext()) {
			SoapHeaderElement headerEle = (SoapHeaderElement) it.next();
			if ("Security".equals(headerEle.getName().getLocalPart())) {
				
				DOMSource src = (DOMSource)headerEle.getSource();
				Node node = src.getNode();
				
				Node userNameNode = node.getFirstChild();
				
				NodeList nodes = node.getChildNodes();
				for ( int i=0; i< nodes.getLength(); i++ ){
					Node currNode = nodes.item(i);
					System.out.println("Current node :" + currNode.getLocalName());
					String nodeLocalName = currNode.getLocalName();
					if ( nodeLocalName != null && "UsernameToken".equals(nodeLocalName) ) {
						NodeList userNodes = currNode.getChildNodes();
						for ( int j=0; j< userNodes.getLength(); j++ ){ 
							Node currUserNode = userNodes.item(j);
							
							String userNodeName = currUserNode.getLocalName();
							System.out.println("userNodeName :" + userNodeName);
							if (userNodeName != null && "Username".equalsIgnoreCase(userNodeName) ) {
								userName = currUserNode.getTextContent();
								System.out.println("userName :" + userName);
							}
						}
					}
					
				}
				context.setProperty("USERNAME",userName);
			}
		}

	}

	public static void removeMessageContext() {
		threadLocal.remove();
	}

	public static Exception getException() {
		return (Exception)getMessageContext().getProperty("EXCEPTION");
	}

	public static void setException(Exception exception) {
		if ( getMessageContext() != null)
		getMessageContext().setProperty("EXCEPTION", exception);
	}

	public static ServiceLog getServiceLog() {
		return (ServiceLog)getMessageContext().getProperty("SERVICELOG");
	}

	public static void setServiceLog(ServiceLog serviceLog) {
		getMessageContext().setProperty("SERVICELOG", serviceLog);
	}

	public static ServiceUser getServiceUser() {
		return (ServiceUser)getMessageContext().getProperty("SERVICEUSER");
	}

	public static void setServiceUser(ServiceUser serviceUser) {
		getMessageContext().setProperty("SERVICEUSER", serviceUser);
	}
}
