package gov.va.med.esr.webservices.jaxws;

import gov.va.med.esr.delegates.MSDelegate;
import gov.va.med.esr.mvc.controller.PersonFilterType;
import gov.va.med.esr.mvc.model.MSModel;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.BindingType;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@WebService(serviceName="jaxwsMS")
@SOAPBinding(style = SOAPBinding.Style.DOCUMENT, use = SOAPBinding.Use.LITERAL, parameterStyle = SOAPBinding.ParameterStyle.WRAPPED)
@BindingType(value=javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING)
public class MSEndpoint extends SpringBeanAutowiringSupport implements MSEndpointOperations {
    private MSDelegate msDelegate;
    
	/* (non-Javadoc)
	 * @see gov.va.med.esr.webservices.jaxws.MSEndpointOperations#getSummary(java.lang.String, java.lang.String)
	 */   
	public MSModel getMSSummary(String key, String keyType) {
		return (MSModel) getMsDelegate().getData(PersonFilterType.convertPersonFilter(key, keyType));		
	}
	

	private MSDelegate getMsDelegate() {
		return msDelegate;
	}

	@Autowired
	public void setMsDelegate(MSDelegate msDelegate) {
		this.msDelegate = msDelegate;
	}
}
