package gov.va.med.esr.webservices.jaxws;

import gov.va.med.esr.delegates.EEDelegate;
import gov.va.med.esr.mvc.controller.PersonFilterType;
import gov.va.med.esr.mvc.model.EEModel;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.ws.BindingType;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@WebService(serviceName="jaxwsEE")
@SOAPBinding(style = SOAPBinding.Style.DOCUMENT, use = SOAPBinding.Use.LITERAL, parameterStyle = SOAPBinding.ParameterStyle.WRAPPED)
@BindingType(value=javax.xml.ws.soap.SOAPBinding.SOAP12HTTP_BINDING)
public class EEEndpoint extends SpringBeanAutowiringSupport implements EEEndpointOperations
	{
    private EEDelegate eeDelegate;
    
    

    
	/* (non-Javadoc)
	 * @see gov.va.med.esr.webservices.jaxws.EEEndpointOperations#getSummary(java.lang.String, java.lang.String)
	 */
	public EEModel getEESummary(String key, String keyType) {
		EEModel model = getEEDelegate().getData(PersonFilterType.convertPersonFilter(key, keyType));
		return  model;
	}
	
	@Autowired
	private void setEEDelegate(EEDelegate eeDelegate) {
		this.eeDelegate = eeDelegate;
		System.out.print("setting the eeDelegate");
	}
	
	
	private EEDelegate getEEDelegate() {
		return eeDelegate;
	}
	
}
