package gov.va.med.esr.webservices.client;

import gov.va.med.esr.mvc.controller.PersonFilterType;
import gov.va.med.esr.mvc.model.EEModel;
import gov.va.med.esr.mvc.model.MSModel;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.MSSummary;
import gov.va.med.esr.webservices.jaxws.EEEndpointOperations;
import gov.va.med.esr.webservices.jaxws.MSEndpointOperations;

import java.io.File;
import java.net.URL;

import org.springframework.remoting.jaxws.JaxWsPortProxyFactoryBean;

public class SampleClientJaxWs {
	//public static final String WS_URL = "https://isa-kavuritr-lt:7002/";
	//public static  String WSDL_URL= "https://isa-kavuritr-lt:7002/esr-ws/ee.wsdl";
	//public static  String WSDL_URL= "file://D:/Documents and Settings/Administrator/Desktop/ee.wsdl";
	
	public static  String WS_URL = "https://isa-kavuritr-lt:7002/";
	public static  String WSDL_URL= "https://isa-kavuritr-lt:7002/esr-ws/jaxws";
	/**
	 * @param args
	 */
	public static void main(String[] args) throws Exception {
		
		try {
			java.net.InetAddress localMachine = java.net.InetAddress.getLocalHost();
				System.out.println("Hostname of local machine: " + localMachine.getHostName());
				String lHostName = localMachine.getHostName();
				if ( lHostName != null && lHostName.length() > 0 )
				{
					WS_URL = "https://" + lHostName + ":7002/";
					WSDL_URL = "https://" + lHostName + ":7002/esr-ws/jaxws";
				}
			}
			catch (java.net.UnknownHostException uhe) { 
			}
		//System.setProperty("javax.net.debug", "all");
		
		//WSDL_URL = WSDL_URL.replace('/', File.separatorChar);
		System.out.println("trustStore :" + System.getProperty("javax.net.ssl.trustStore"));
		if(System.getProperty("javax.net.ssl.trustStore") == null) {
			//String trustStoreName = System.getProperty("trustStoreName",
			//		"jssecacerts");
			//String trustStorePassword = System.getProperty(
			//		"javax.net.ssl.trustStorePassword", "changeit");
	
			//String trustStoreName = "jssecacerts";
			String trustStoreName =
			"D:/bea/projects/ESR.3.0.0/DNS   kavurt_HECMS_Websrv_1/vobs/HECMS_websrv/jssecacerts";
			
			trustStoreName = trustStoreName.replace('/', File.separatorChar);
			String trustStorePassword = "changeit";
			
			System.out.println("trustStoreName :" + trustStoreName);
			String detectedAbsolutePath = trustStoreName;
			
			//String detectedAbsolutePath = ClassLoader.getSystemResource(
			//		trustStoreName).getFile(); // assumes classpath can find it
			System.setProperty("javax.net.ssl.trustStore", detectedAbsolutePath);
			System.setProperty("javax.net.ssl.trustStorePassword",
					trustStorePassword);
			
			
			
		}
		
		
     	
		testEE();
		testMS();
	}
	


	
	public static void testEE() throws Exception {
		try {
			EEEndpointOperations webservice = (EEEndpointOperations)
				getWSInterface("jaxwsEE", "ee", gov.va.med.esr.webservices.jaxws.EEEndpointOperations.class);
			
			EEModel pojo = webservice.getEESummary("0000002000000001V143771000000", PersonFilterType.VPID.name());
			System.out.println(((EESummary) pojo.getServiceData()));
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	public static void testMS() throws Exception {
		try {
			MSEndpointOperations webservice = (MSEndpointOperations)
				getWSInterface("jaxwsMS","ms", gov.va.med.esr.webservices.jaxws.MSEndpointOperations.class);
			
			MSModel pojo = webservice.getMSSummary("123456789", PersonFilterType.SSN.name());
			System.out.println(((MSSummary) pojo.getServiceData()));
		} catch(Exception e) {
			e.printStackTrace();
		}	
	}
	
	private static Object getWSInterface(String key, String wsdlname , Class serviceInterface) throws Exception {
		JaxWsPortProxyFactoryBean factory = new JaxWsPortProxyFactoryBean();
		factory.setServiceInterface(serviceInterface);
		factory.setWsdlDocumentUrl(new URL(WSDL_URL+wsdlname+".wsdl"));
		factory.setNamespaceUri("http://jaxws.webservices.esr.med.DNS   /");
		factory.setServiceName(key);
		factory.setPortName(wsdlname.toUpperCase() + "EndpointPort");
		factory.afterPropertiesSet();
		factory.setUsername("tester1");
		factory.setPassword("Password1!");
		return factory.getObject();
	}
	
}
