package gov.va.med.esr.webservices.client;

import gov.va.med.esr.mvc.model.GetEESummaryRequest;

import java.io.FileInputStream;
import java.io.FileOutputStream;

import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

public class Jaxb2Test {


	    private static final String FILE_NAME = "C:\\eeRequest.xml";
	    private GetEESummaryRequest eeRequest = new GetEESummaryRequest();
	    
	    private Marshaller marshaller;
	    private Unmarshaller unmarshaller;

	    public void setMarshaller(Marshaller marshaller) {
	        this.marshaller = marshaller;
	    }

	    public void setUnmarshaller(Unmarshaller unmarshaller) {
	        this.unmarshaller = unmarshaller;
	    }

		public Marshaller createMarshaller() throws Exception {
			Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
			
			//CastorMarshaller marshaller = new CastorMarshaller();
			//marshaller.setMappingLocation(new FileSystemResource("D:\\bea\\projects\\ESR.3.0.0\\DNS   kavurt_HECMS_Websrv_1\\vobs\\HECMS_websrv\\src\\main\\webapp\\WEB-INF\\eeSummary.xsd") );
			
			String currDir = System.getenv("user.dir");
			
			System.out.println(" Curr Dir = " + currDir);
			
			Class[] classesToBeBound = new Class[1];
			classesToBeBound[0] = gov.va.med.esr.mvc.model.GetEESummaryRequest.class;

			marshaller.setClassesToBeBound(classesToBeBound);
			marshaller.setSchema(new FileSystemResource("D:\\bea\\projects\\ESR.3.0.0\\DNS   kavurt_HECMS_Websrv_1\\vobs\\HECMS_websrv\\src\\main\\webapp\\WEB-INF\\eeSummary.xsd") );
			
			marshaller.afterPropertiesSet();
			return marshaller;
		}

		public Unmarshaller createUnMarshaller() throws Exception {
			Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
			//marshaller.setContextPath(CONTEXT_PATH);
			//marshaller.
			Class[] classesToBeBound = new Class[1];
			classesToBeBound[0] = gov.va.med.esr.mvc.model.GetEESummaryRequest.class;
			marshaller.setClassesToBeBound(classesToBeBound);
			marshaller.setSchema(new FileSystemResource("D:\\bea\\projects\\ESR.3.0.0\\DNS   kavurt_HECMS_Websrv_1\\vobs\\HECMS_websrv\\src\\main\\webapp\\WEB-INF\\eeSummary.xsd") );
			
			marshaller.afterPropertiesSet();
			return marshaller;
		}

	    public void saveSettings() throws Exception {
	        FileOutputStream os = null;
	        try {
	            os = new FileOutputStream(FILE_NAME);
	            
	            eeRequest.setKey("1111V11111100");
	            eeRequest.setKeyType("VPID");
	            
	            //createMarshaller().marshal(eeRequest, new StreamResult(os));
	            marshaller.marshal(eeRequest, new StreamResult(os));
	        } finally {
	            if (os != null) {
	                os.close();
	            }
	        }
	    }

	    public void loadSettings() throws Exception {
	        FileInputStream is = null;
	        try {
	        	
	            is = new FileInputStream(FILE_NAME);
	            this.eeRequest = (GetEESummaryRequest) ((Unmarshaller)marshaller).unmarshal(new StreamSource(is));
	            System.out.println("Key is : " + eeRequest.getKey());
	            System.out.println("Key Type is : " + eeRequest.getKeyType());
	            
	            
	        } finally {
	            if (is != null) {
	                is.close();
	            }
	        }
	    }

	    public static void main(String[] args) throws Exception {
      
	    	 ApplicationContext appContext =
	             new ClassPathXmlApplicationContext("/WEB-INF/spring-ws-servlet.xml");
	    	 Jaxb2Test test = (Jaxb2Test) appContext.getBean("jaxb2Test");
	    	test.saveSettings();
	    	test.loadSettings();
	    }
}
