package gov.va.med.esr.service;

import gov.va.med.esr.model.ServiceUser;
import gov.va.med.esr.persistence.hibernate.ServiceUserDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;

public class UserServiceImpl extends AbstractComponent implements UserService {

	private  ServiceUserDAO serviceUserDAO;

	public ServiceUserDAO getServiceUserDAO() {
		return serviceUserDAO;
	}

	public void setServiceUserDAO(ServiceUserDAO serviceUserDAO) {
		this.serviceUserDAO = serviceUserDAO;
	}
	
	public ServiceUser getUserByUserName(String userName) throws ServiceException{
		try {
			return serviceUserDAO.getUserByUserName(userName);
		} catch ( DAOException de) {
			throw new ServiceException(de);
		}
		
		
	}

}
