package gov.va.med.esr.mvc.model;

import gov.va.med.esr.service.external.person.IVMCandidateInfo;
import gov.va.med.esr.service.external.person.collections.IVMCandidateCollection;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(
		name = "retrieveIVMCandidatesResponse", 
		namespace = "http://jaxws.webservices.esr.med.DNS   /schemas"
			)
@XmlAccessorType(XmlAccessType.FIELD)
public class RetrieveIVMCandidatesResponse extends AbstractServiceDataWrapperImpl {
	private static final long serialVersionUID = 4118300693925179445L;
	private List<IVMCandidateInfo> candidates;
	private String eesVersion;
	private Integer numberOfCandidates;
	
	public Object getServiceData() {
		return getCandidates();
	}

	@SuppressWarnings("unchecked")
	public void setServiceData(Object serviceData) {
		setCandidates((List<IVMCandidateInfo>) serviceData);
	}

	public List<IVMCandidateInfo> getCandidates() {
		return candidates;
	}

	public void setCandidates(List<IVMCandidateInfo> candidates) {
		this.candidates = candidates;
	}

	public String getEesVersion() {
		return eesVersion;
	}

	public void setEesVersion(String eesVersion) {
		this.eesVersion = eesVersion;
	}

	public Integer getNumberOfCandidates() {
		return numberOfCandidates;
	}

	public void setNumberOfCandidates(Integer numberOfCandidates) {
		this.numberOfCandidates = numberOfCandidates;
	}
	
}
