package gov.va.med.esr.mvc.controller;

import gov.va.med.esr.service.external.EntityFinder;
import gov.va.med.esr.service.external.person.PersonFinderFactory;
//import gov.va.med.esr.mvc.model.CategoryInfo;
//import gov.va.med.esr.mvc.model.CategoryCollection;
import gov.va.med.esr.service.external.person.collections.CategoryCollection;
import gov.va.med.esr.service.external.person.CategoryInfo;
import gov.va.med.esr.service.external.person.DeliveryPreferenceInfo;
import gov.va.med.esr.service.external.person.EntityKeyFactory;

import java.util.Date;

public enum PersonFilterType {
	VPID, SSN, LNS,EDIPI, SEARCH;
	
	public static EntityFinder convertPersonFilter(String filterKey, String filterType) {
	
		/**
		if(filterType == null || VPID.name().equalsIgnoreCase(filterType)) {
			return PersonFinderFactory.createVPIDFinder(filterKey);
		} else if(SSN.name().equalsIgnoreCase(filterType)) {
			return PersonFinderFactory.createSSNFinder(filterKey);
		} else if(LNS.name().equalsIgnoreCase(filterType)) {
			return PersonFinderFactory.createLNSFinder(filterKey);
		}
			
		throw new IllegalArgumentException("Unknown PersonFilter type: " + filterType);
		**/
		return null;
	}	
	
	public static EntityFinder convertPersonFilter(String filterKey, String filterType, String accountName, String requestName) {
		
		if(filterType == null || VPID.name().equalsIgnoreCase(filterType)) {
			return PersonFinderFactory.createVPIDFinder(filterKey,accountName, requestName);
		}else if(EDIPI.name().equalsIgnoreCase(filterType)){
			return PersonFinderFactory.createEDIPIFinder(filterKey,accountName, requestName);
		} else if(SSN.name().equalsIgnoreCase(filterType)) {
			return PersonFinderFactory.createSSNFinder(filterKey,accountName, requestName);
		} else if(LNS.name().equalsIgnoreCase(filterType)) {
			return PersonFinderFactory.createLNSFinder(filterKey, accountName, requestName);
		}
			
		throw new IllegalArgumentException("Unknown PersonFilter type: " + filterType);
	}
	
	public static EntityFinder convertPersonFilter(String filterKey, Integer incomeYear, String filterType, String accountName, String requestName) {
		
		if(filterType == null || VPID.name().equalsIgnoreCase(filterType)) {
			return PersonFinderFactory.createVPIDFinder(filterKey, incomeYear,accountName, requestName);
		}else if(EDIPI.name().equalsIgnoreCase(filterType)){
			return PersonFinderFactory.createEDIPIFinder(filterKey, incomeYear,accountName, requestName);
		} else if(SSN.name().equalsIgnoreCase(filterType)) {
			return PersonFinderFactory.createSSNFinder(filterKey, incomeYear,accountName, requestName);
		} else if(LNS.name().equalsIgnoreCase(filterType)) {
			return PersonFinderFactory.createLNSFinder(filterKey, incomeYear, accountName, requestName);
		}
			
		throw new IllegalArgumentException("Unknown PersonFilter type: " + filterType);
	}
  
   
    public static EntityFinder convertPersonFilter(String filterKey, String filterType, String accountName, String requestName, CategoryCollection categories) {
        if(filterType == null || VPID.name().equalsIgnoreCase(filterType)) {
            return PersonFinderFactory.createVPIDFinder(filterKey,accountName, requestName,categories);
        } else if(SSN.name().equalsIgnoreCase(filterType)) {
            return PersonFinderFactory.createSSNFinder(filterKey,accountName, requestName,categories);
        } else if(LNS.name().equalsIgnoreCase(filterType)) {
            return PersonFinderFactory.createLNSFinder(filterKey, accountName, requestName,categories);
        }
            
        throw new IllegalArgumentException("Unknown PersonFilter type: " + filterType);
    }
    
    public static EntityFinder convertPersonFilter(String data, String filterType, String accountName, String notificationType, String survivingVpid, String deprecatedVpid, String dfn, String stationNumber, 
            String fromVpid, String toVpid) {
        if(filterType == null || VPID.name().equalsIgnoreCase(filterType)) {
            return PersonFinderFactory.createVPIDFinder(data,accountName, null,notificationType,survivingVpid,deprecatedVpid,dfn,stationNumber,fromVpid,toVpid);
        }
        throw new IllegalArgumentException("Unknown PersonFilter type: " + filterType);
    
    }
    public static EntityFinder convertPersonFilter(String filterKey, String filterType, String accountName, String requestName, DeliveryPreferenceInfo deliveryPreferenceInfo) {
        if(filterType == null || VPID.name().equalsIgnoreCase(filterType)) {
            return PersonFinderFactory.createVPIDFinder(filterKey,accountName, requestName,deliveryPreferenceInfo);
        } 
        throw new IllegalArgumentException("Unknown PersonFilter type: " + filterType);
    }
}
