package gov.va.med.esr.mvc.controller;

import gov.va.med.esr.delegates.MSDelegate;
import gov.va.med.esr.mvc.model.MSModel;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("/veteran/{key}/ms")
public class MSController extends AbstractController {
    private final MSDelegate msDelegate;
    
    @Autowired
    public MSController(MSDelegate msDelegate) {
        this.msDelegate = msDelegate;
    }
	
	@RequestMapping(method=RequestMethod.GET)
	@ResponseBody
    public MSModel get(@PathVariable("key") String key, @RequestParam(value="keyType", required=false) String keyType) {
        return msDelegate.getData(PersonFilterType.convertPersonFilter(key, keyType));
    }    
}
