package gov.va.med.esr.mvc.controller;

import gov.va.med.esr.delegates.EEDelegate;
import gov.va.med.esr.mvc.model.EEModel;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("/veteran/{key}/ee")
public class EEController extends AbstractController {
    private final EEDelegate eeDelegate;
    
    @Autowired
    public EEController(EEDelegate eeDelegate) {
        this.eeDelegate = eeDelegate;
    }	

	@RequestMapping(method=RequestMethod.GET)
	@ResponseBody
    public EEModel get(@PathVariable("key") String key, @RequestParam(value="keyType", required=false) String keyType) {
        return eeDelegate.getData(PersonFilterType.convertPersonFilter(key, keyType));
    }    
}