package gov.va.med.esr.delegates;

import gov.va.med.esr.mvc.model.MSModel;
import gov.va.med.esr.service.external.EntityFinder;
import gov.va.med.esr.service.external.person.MSSummary;
import gov.va.med.esr.service.external.person.PIIData;
import gov.va.med.esr.service.external.person.PersonService;

public class MSDelegate {
	private PersonService personService;
	
	public MSModel getData(EntityFinder finder) {
		return invokeService(finder);
	}

	private MSModel invokeMock(EntityFinder finder) {
		MSSummary summary = new MSSummary();
		PIIData pii = new PIIData();
		pii.setVpid(finder.getFinderData());
		summary.setPiiData(pii);
		summary.setLastServiceBranchCode("USAF");
		summary.setLastServiceNumber("xbnmf123");
		MSModel wrapper = new MSModel();
		wrapper.setServiceData(summary);					
		return wrapper;
	}
	
	private MSModel invokeService(EntityFinder finder) {
		try {
			MSSummary soaResult = personService.getMSSummary(finder);
			MSModel wrapper = new MSModel();
			wrapper.setServiceData(soaResult);								
			return wrapper;
		} catch(Exception e) {
			throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
		}
	}
	
	public void setPersonService(PersonService personService) {
		this.personService = personService;
	}
}
