package gov.va.med.esr.delegates;

import gov.va.med.esr.mvc.model.EDStatusModel;
import gov.va.med.esr.mvc.model.EEModel;
import gov.va.med.esr.mvc.model.EEModelHistory;

import gov.va.med.esr.mvc.model.PersonNotificationModel;
import gov.va.med.esr.service.external.ESRException;
import gov.va.med.esr.service.external.EntityFinder;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.IVMLastPolledEntityFinder;
import gov.va.med.esr.service.external.person.IVMRecordStatusEntityFinder;
import gov.va.med.esr.service.external.person.IVMSummary;
import gov.va.med.esr.service.external.person.PIIData;
import gov.va.med.esr.service.external.person.PersonService;
import gov.va.med.esr.service.external.person.VPIDEntityFinder;
import gov.va.med.esr.mvc.model.DeliveryPreferenceModel;
import gov.va.med.esr.mvc.model.UpdateDeliveryPreferenceModel;


public class EEDelegate {
	private PersonService personService;

	public EEModel getData(EntityFinder finder) {
		return invokeService(finder);
	}

    public EEModelHistory getDataHistory(EntityFinder finder) {
        return invokeServiceHistory(finder);
    }
    public EDStatusModel getDataEDStatus(EntityFinder finder) {
        return invokeServiceEDStatus(finder);
    }
  
    public PersonNotificationModel getDataPersonNotificationStatus(EntityFinder finder) {
        return invokeServicePersonNotificationStatus(finder);
    }
    public DeliveryPreferenceModel getDataDeliveryPreference(EntityFinder finder) {
        return invokeServiceDeliveryPreference(finder);
    }
    public UpdateDeliveryPreferenceModel getDataUpdateDeliveryPreference(EntityFinder finder) {
        return invokeServiceUpdateDeliveryPreference(finder);
    }
	private EEModel invokeMock(EntityFinder finder) {
		EESummary summary = new EESummary();
		PIIData pii = new PIIData();
		pii.setVpid(finder.getFinderData());

		EEModel wrapper = new EEModel();
		wrapper.setServiceData(summary);
		return wrapper;
	}

	private EEModel invokeService(EntityFinder finder) {
		try {
			EESummary soaResult = personService.getEESummary(finder);
			EEModel wrapper = new EEModel();
			wrapper.setServiceData(soaResult);
			return wrapper;
		} catch(Exception e) {
			throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
		}
	}

    private EEModelHistory invokeServiceHistory(EntityFinder finder) {
        try {
            EESummary soaResult = personService.getEESummaryHistory(finder);
            EEModelHistory wrapper = new EEModelHistory();
            wrapper.setServiceData(soaResult);
            return wrapper;
        } catch(Exception e) {
            throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
        }
    }

    

    private EDStatusModel invokeServiceEDStatus(EntityFinder finder) {
		try {
			EESummary soaResult = personService.getEDStatus(finder);
			EDStatusModel wrapper = new EDStatusModel();
			wrapper.setServiceData(soaResult);
			return wrapper;
		} catch(Exception e) {
			throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
		}
	}

    private PersonNotificationModel invokeServicePersonNotificationStatus(EntityFinder finder) {
		try {
			EESummary soaResult = personService.getPersonNotificationStatus(finder);
			PersonNotificationModel wrapper = new PersonNotificationModel();
			wrapper.setServiceData(soaResult);
			return wrapper;
		} catch(Exception e) {
			throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
		}
	}

    private DeliveryPreferenceModel invokeServiceDeliveryPreference(EntityFinder finder) {
		try {
			EESummary soaResult = personService.getDeliveryPreference(finder);
			DeliveryPreferenceModel wrapper = new DeliveryPreferenceModel();
			wrapper.setServiceData(soaResult);
			return wrapper;
		} catch(Exception e) {
			throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
		}
	}

    private UpdateDeliveryPreferenceModel invokeServiceUpdateDeliveryPreference(EntityFinder finder) {
        try {
            EESummary soaResult = personService.updateDeliveryPreference(finder);
            UpdateDeliveryPreferenceModel wrapper = new UpdateDeliveryPreferenceModel();
            wrapper.setServiceData(soaResult);
            return wrapper;
        } catch(Exception e) {
            throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
        }
    }
	public PersonService getPersonService() {
		return personService;
	}

	public void setPersonService(PersonService personService) {
		this.personService = personService;
	}

	public IVMSummary getIVMCandidatesData(IVMLastPolledEntityFinder finder) {
		try {
			return personService.retrieveIVMCandidates(finder);
		} catch (ESRException e) {
			 throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
		}
	}

	// ES 4.0_CodeCR12863_CR_EE Web Service Updates
	public IVMSummary getIvmLetterCandidatesData() {
		try {
			return personService.retrieveIVMLetterCandidates();
		} catch (ESRException e) {
			 throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
		}
	}

	public IVMSummary getIVMRecordStatusData(IVMRecordStatusEntityFinder finder) {
		try {
			return personService.updateIVMStatus(finder);
		} catch (ESRException e) {
			 throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
		}
	}

	public IVMSummary getSendIVMUpdatesData(VPIDEntityFinder vpidEntityFinder) {
		try {
			return personService.processIVMIncomeTest(vpidEntityFinder);
		} catch (ESRException e) {
			 throw new RuntimeException("Unable to invoke SOA ESR due to: " + e.getMessage(), e);
		}
	}

}
