#=======================================================================================
# WLST script to create Weblogic domain for Preproduction
# 1.Please Change the password for user weblogic
# 2. Enter the password for dbpassword
#
#=======================================================================================

# Please enter values for these fields
adminpassword='[ENTER_VALUE_HERE]'
dbpasword='[ENTER_VALUE_HERE]'


#Define variables like Server name etc.
AdminServerPORT     
AdminServerSSLPORT     
domainName='EES-PROD'


#Managed Server 1
MS1Name='EEMS1'
MS1PORT     
MS1SSLPORT     
Machine1_Name='EEMS1Machine'
NodeManagerPORT     
MS1hostname='DNS   app45.aac.DNS   '


MS2Name='EEMS2'
MS2PORT     
MS2SSLPORT     
Machine2_Name='EEMS2Machine'
NodeManagerPORT     
MS2hostname='DNS   app46.aac.DNS   '



domainfolder= os.environ['EEDOMAIN_HOME']

#=======================================================================================
# Open a domain template.
#=======================================================================================

print "Reading Template"
readTemplate("../templates/esr-ws_10.3.2.0.jar")
set('Name',domainName)
#=======================================================================================
# Configure the Administration Server and SSL port.
#
# To enable access by both local and remote processes, you should not set the 
# listen address for the server instance (that is, it should be left blank or not set). 
# In this case, the server instance will determine the address of the machine and 
# listen on it. 
#=======================================================================================

print "Creating Admin Server"

cd('Servers/AdminServer')
set('ListenAddress','')
set('ListenPort', AdminServerPort)

create('AdminServer','SSL')
cd('SSL/AdminServer')
set('Enabled', 'True')
set('ListenPort', AdminServerSSLPort)



#=======================================================================================
# Configure the Machine 1
#=======================================================================================

print "Creating Machine1 "
cd('/')
create(Machine1_Name, 'Machine')
cd('/Machine/'+Machine1_Name)
create(Machine1_Name, 'NodeManager')
cd('NodeManager/'+Machine1_Name)
set('ListenAddress', MS1hostname)
set('NMType','SSL')
set('ListenPort',NodeManagerPort)
set('DebugEnabled','false')



#=======================================================================================
# Configure the Machine 2
#=======================================================================================

print "Creating Machine2 "
cd('/')
create(Machine2_Name, 'Machine')
cd('/Machine/'+Machine2_Name)
create(Machine2_Name, 'NodeManager')
cd('NodeManager/'+Machine2_Name)
set('ListenAddress', MS2hostname)
set('NMType','SSL')
set('ListenPort',NodeManagerPort)
set('DebugEnabled','false')





#=======================================================================================
# Define the user password for weblogic.
#=======================================================================================

cd('/')
cd('Security/'+domainName +'/User/weblogic')
# Please set password here before using this script, e.g. 
cmo.setPassword(adminpassword)


print "Creating Server :" + MS1Name


cd('/')
create(MS1Name, 'Server')
cd('Servers/'+MS1Name)
set('ListenAddress', '')
set('ListenPort', MS1Port)

create(MS1Name, 'SSL')
cd('SSL/'+MS1Name)
set('Enabled','True')
set('ListenPort', MS1SSLPort)

cd('/Servers/'+MS1Name)
set('ListenAddress',MS1hostname)
set('ListenPortEnabled','true')
set('Machine',Machine1_Name)
set('JavaCompilerPreClassPath', os.environ['BEA_HOME']+r'/server/lib/jsafeFIPS.jar');



print "Creating Server :" + MS2Name

cd('/')
create(MS2Name, 'Server')
cd('Servers/'+MS2Name)
set('ListenAddress', '')
set('ListenPort', MS2Port)

create(MS2Name, 'SSL')
cd('SSL/'+MS2Name)
set('Enabled','True')
set('ListenPort', MS2SSLPort)

cd('/Servers/'+MS2Name)
set('ListenAddress',MS2hostname)
set('ListenPortEnabled','true')
set('Machine',Machine1_Name)
set('JavaCompilerPreClassPath', os.environ['BEA_HOME']+r'/server/lib/jsafeFIPS.jar');




print "Creating ServerStart... :" + MS1Name
cd('/Servers/'+MS1Name)
create(MS1Name,'ServerStart')
cd('/Servers/'+MS1Name+'/ServerStart/'+MS1Name)
set('Arguments', '-Xms2560m -Xmx2560m -XX:NewSize=512m -XX:MaxPermSize=512m -XX:+UseParallelGC -XX:SurvivorRatio=5 -XX:+UseCMSCompactAtFullCollection -XX:CMSFullGCsBeforeCompaction=0 -Dweblogic.security.SSL.protocolVersion=TLS1  -Dweblogic.security.SSL.nojce=true ')


print "Creating ServerStart... :" + MS2Name
cd('/Servers/'+MS2Name)
create(MS2Name,'ServerStart')
cd('/Servers/'+MS2Name+'/ServerStart/'+MS2Name)
set('Arguments', '-Xms2560m -Xmx2560m -XX:NewSize=512m -XX:MaxPermSize=512m -XX:+UseParallelGC -XX:SurvivorRatio=5 -XX:+UseCMSCompactAtFullCollection -XX:CMSFullGCsBeforeCompaction=0 -Dweblogic.security.SSL.protocolVersion=TLS1  -Dweblogic.security.SSL.nojce=true ')



print "Creating Cluster... " 
cd('/')
create('EECluster', 'Cluster')

assign('Server', MS1Name,'Cluster','EECluster')
assign('Server', MS2Name,'Cluster','EECluster')


cd('/Clusters/EECluster')
cmo.setClusterAddress('DNS   app45.aac.DNS   :7101,DNS   app46.aac.DNS   :7101')
cmo.setDefaultLoadAlgorithm('round-robin')

print "Creating Connection pool... "

cd('/')
delete('EEService','JDBCSystemResource')
create('EESPool', 'JDBCSystemResource')
cd('JDBCSystemResource/EESPool/JdbcResource/EESPool')
create('myJdbcDriverParams','JDBCDriverParams')
cd('JDBCDriverParams/NO_NAME_0')
set('DriverName','oracle.jdbc.OracleDriver')
set('URL','jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=edbclu01.aac.DNS   )(PORT     )))(CONNECT_DATA=(SERVICE_NAME=ADRP.AAC.DNS   )))')
set('PasswordEncrypted', dbpasword)
set('UseXADataSourceInterface', 'false')
create('myProps','Properties')
cd('Properties/NO_NAME_0')
create('user', 'Property')
cd('Property/user')
cmo.setValue('eesrvusr')

cd('/JDBCSystemResource/EESPool/JdbcResource/EESPool')
create('myJdbcDataSourceParams','JDBCDataSourceParams')
cd('JDBCDataSourceParams/NO_NAME_0')
set('JNDIName', java.lang.String("eeservice.jdbc.DataSource.OLTP"))

cd('/JDBCSystemResource/EESPool/JdbcResource/EESPool')
create('myJdbcConnectionPoolParams','JDBCConnectionPoolParams')
cd('JDBCConnectionPoolParams/NO_NAME_0')
set('TestTableName','DUAL')
set('MaxCapacity',40)
set('CapacityIncrement',5)
set('TestConnectionsOnReserve','true')
set('InitialCapacity',10)


#=======================================================================================
# Target resources to the servers. 
#=======================================================================================

cd('/')
assign('JDBCSystemResource', 'EESPool', 'Target', 'EECluster')

#=======================================================================================
# Write the domain and close the domain template.
#=======================================================================================

setOption('OverwriteDomain', 'true')

print" Writing domain to:" + domainfolder
writeDomain(domainfolder)
closeTemplate()
print "Domain Created successfully... "

#=======================================================================================
# Exit WLST.
#=======================================================================================

exit()

