#=======================================================================================
# This is an example of a simple WLST offline configuration script. The script creates 
# a simple WebLogic domain using the Basic WebLogic Server Domain template. The script 
# demonstrates how to open a domain template, create and edit configuration objects, 
# and write the domain configuration information to the specified directory.
#
# This sample uses the demo Pointbase Server that is installed with your product.
# Before starting the Administration Server, you should start the demo Pointbase server
# by issuing one of the following commands:
#
# Windows: WL_HOME\common\eval\pointbase\tools\startPointBase.cmd
# UNIX: WL_HOME/common/eval/pointbase/tools/startPointBase.sh
#
# (WL_HOME refers to the top-level installation directory for WebLogic Server.)
#
# The sample consists of a single server, representing a typical development environment. 
# This type of configuration is not recommended for production environments.
#
# Please note that some of the values used in this script are subject to change based on 
# your WebLogic installation and the template you are using.
#
# Usage: 
#      java weblogic.WLST <WLST_script> 
#
# Where: 
#      <WLST_script> specifies the full path to the WLST script.
#=======================================================================================

#Define variables like Server name etc.
AdminServerPORT     
AdminServerSSLPORT     

MS1Name='EEMS1'
MS1PORT     
MS1SSLPORT     
domainName='EES-DEV'
Machine_Name='EEMS1Server'
NodeManagerPORT     
MS1hostname='DNS   app41.aac.DNS   '

adminpassword='weblogic123'

dbpasword='PW            '

domainfolder= os.environ['EEDOMAIN_HOME']

#=======================================================================================
# Open a domain template.
#=======================================================================================

print "Reading Template"
readTemplate("../templates/esr-ws_10.3.2.0.jar")
set('Name',domainName)
#=======================================================================================
# Configure the Administration Server and SSL port.
#
# To enable access by both local and remote processes, you should not set the 
# listen address for the server instance (that is, it should be left blank or not set). 
# In this case, the server instance will determine the address of the machine and 
# listen on it. 
#=======================================================================================

print "Creating Admin Server"

cd('Servers/AdminServer')
set('ListenAddress','')
set('ListenPort', AdminServerPort)

create('AdminServer','SSL')
cd('SSL/AdminServer')
set('Enabled', 'True')
set('ListenPort', AdminServerSSLPort)



#=======================================================================================
# Configure the Machine
#=======================================================================================

print "Creating Machine "
cd('/')
create(Machine_Name, 'Machine')
cd('/Machine/'+Machine_Name)
create(Machine_Name, 'NodeManager')
cd('NodeManager/'+Machine_Name)
set('ListenAddress', MS1hostname)
set('NMType','SSL')
set('ListenPort',NodeManagerPort)
set('DebugEnabled','false')

#=======================================================================================
# Define the user password for weblogic.
#=======================================================================================

cd('/')
cd('Security/'+ domainName +'/User/weblogic')
# Please set password here before using this script, e.g. 
cmo.setPassword(adminpassword)


print "Creating Server :" + MS1Name


cd('/')
create(MS1Name, 'Server')
cd('Servers/'+MS1Name)
set('ListenAddress', '')
set('ListenPort', MS1Port)

create(MS1Name, 'SSL')
cd('SSL/'+MS1Name)
set('Enabled','True')
set('ListenPort', MS1SSLPort)



cd('/Servers/'+MS1Name)
set('ListenAddress',MS1hostname)
set('ListenPortEnabled','true')
#set('AdministrationPort',9002)
#set('JavaCompilerPreClassPath',r'/server/lib/jsafeFIPS.jar')
set('Machine','EEMS1Server')
set('JavaCompilerPreClassPath', os.environ['BEA_HOME']+r'/server/lib/jsafeFIPS.jar');


print "Creating ServerStart... :" + MS1Name
cd('/Servers/'+MS1Name)
create(MS1Name,'ServerStart')
cd('/Servers/'+MS1Name+'/ServerStart/'+MS1Name)
set('Arguments', '-Xms2560m -Xmx2560m -XX:NewSize=512m -XX:MaxPermSize=512m -XX:+UseParallelGC -XX:SurvivorRatio=5 -XX:+UseCMSCompactAtFullCollection -XX:CMSFullGCsBeforeCompaction=0 -Dweblogic.security.SSL.protocolVersion=TLS1  -Dweblogic.security.SSL.nojce=true ')


print "Creating Cluster... " + MS1Name
cd('/')
create('EECluster', 'Cluster')
assign('Server', MS1Name,'Cluster','EECluster')



print "Creating Connection pool... "

cd('/')
delete('EEService','JDBCSystemResource')
create('EESPool', 'JDBCSystemResource')
cd('JDBCSystemResource/EESPool/JdbcResource/EESPool')
create('myJdbcDriverParams','JDBCDriverParams')
cd('JDBCDriverParams/NO_NAME_0')
set('DriverName','oracle.jdbc.OracleDriver')
set('URL','jdbc:oracle:thin:@isaux02.vha.med.DNS   :1521:ADRDEV01')
set('PasswordEncrypted', dbpasword)
set('UseXADataSourceInterface', 'false')
create('myProps','Properties')
cd('Properties/NO_NAME_0')
create('user', 'Property')
cd('Property/user')
cmo.setValue('eesrvusr')

cd('/JDBCSystemResource/EESPool/JdbcResource/EESPool')
create('myJdbcDataSourceParams','JDBCDataSourceParams')
cd('JDBCDataSourceParams/NO_NAME_0')
set('JNDIName', java.lang.String("eeservice.jdbc.DataSource.OLTP"))

cd('/JDBCSystemResource/EESPool/JdbcResource/EESPool')
create('myJdbcConnectionPoolParams','JDBCConnectionPoolParams')
cd('JDBCConnectionPoolParams/NO_NAME_0')
set('TestTableName','DUAL')
set('MaxCapacity',40)
set('CapacityIncrement',5)
set('TestConnectionsOnReserve','true')
set('InitialCapacity',10)


#=======================================================================================
# Target resources to the servers. 
#=======================================================================================

cd('/')
assign('JDBCSystemResource', 'EESPool', 'Target', 'EECluster')

#=======================================================================================
# Write the domain and close the domain template.
#=======================================================================================

setOption('OverwriteDomain', 'true')

print" Writing domain to:" + domainfolder
writeDomain(domainfolder)
closeTemplate()
print "Domain Created successfully... "
#=======================================================================================
# Exit WLST.
#=======================================================================================

exit()

