package gov.va.med.esr.voa.validator;

import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.voa.webservice.ObjectFactory;
import gov.va.med.esr.voa.webservice.SpouseInfo;
import gov.va.med.esr.voa.webservice.SsnCollection;
import gov.va.med.esr.voa.webservice.SsnInfo;
import junit.framework.TestCase;

import org.springframework.validation.BindException;

public class SpouseInfoValidatorTest extends TestCase {

	private SpouseInfoValidator spouseInfoValidator;

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		this.spouseInfoValidator = new SpouseInfoValidator();
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
		this.spouseInfoValidator = null;
	}

	public void testValidSpouse() {
		ObjectFactory factory = new ObjectFactory();
		SpouseInfo spouseInfo = factory.createSpouseInfo();
		spouseInfo.setDob("02/12/1966");
		spouseInfo.setFamilyName("sun");
		spouseInfo.setGivenName("test");
		spouseInfo.setGender("male");
		spouseInfo.setMaidenName("maidenName");
		spouseInfo.setMiddleName("middleName");
		spouseInfo.setRelationship("brother");
		SsnInfo ssnInfo = factory.createSsnInfo();
		ssnInfo.setSsnText("123456789");
		ssnInfo.setType(SSNType.CODE_ACTIVE.getCode());
		SsnCollection ssnCollection = factory.createSsnCollection();
		ssnCollection.getSsn().add(ssnInfo);
		spouseInfo.setSsns(ssnCollection);
		spouseInfo.setStartDate("12/12/1988");

		BindException errors = new BindException(spouseInfo, "spouse");
		this.spouseInfoValidator.validate(spouseInfo, errors);

		TestCase.assertFalse(errors.hasErrors());
	}

}
