package gov.va.med.esr.voa.validator;

import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.voa.webservice.ObjectFactory;
import gov.va.med.esr.voa.webservice.PhoneInfo;
import junit.framework.TestCase;

import org.springframework.validation.BindException;

public class PhoneInfoValidatorTest extends TestCase {

	private PhoneInfoValidator phoneInfoValidator;

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		this.phoneInfoValidator = new PhoneInfoValidator();
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
		this.phoneInfoValidator = null;
	}

	public void testValidPhone() {
		ObjectFactory factory = new ObjectFactory();
		PhoneInfo phoneInfo = factory.createPhoneInfo();
		phoneInfo.setPhoneNumber("7032340987");
		phoneInfo.setType(PhoneType.CODE_HOME.getCode());

		BindException errors = new BindException(phoneInfo, "phone");
		phoneInfoValidator.validate(phoneInfo, errors);

		TestCase.assertFalse(errors.hasErrors());

		phoneInfo.setType(PhoneType.CODE_MOBILE.getCode());
		phoneInfoValidator.validate(phoneInfo, errors);

		TestCase.assertFalse(errors.hasErrors());
	}

	public void testInvalidPhone1() {
		ObjectFactory factory = new ObjectFactory();
		PhoneInfo phoneInfo = factory.createPhoneInfo();
		phoneInfo.setPhoneNumber("703***3333");
		phoneInfo.setType(PhoneType.CODE_HOME.getCode());

		BindException errors = new BindException(phoneInfo, "phone");
		phoneInfoValidator.validate(phoneInfo, errors);

		TestCase.assertTrue(errors.hasErrors());

		phoneInfo.setPhoneNumber("703");
		phoneInfo.setType(PhoneType.CODE_MOBILE.getCode());
		
		phoneInfoValidator.validate(phoneInfo, errors);
		
		TestCase.assertTrue(errors.getErrorCount() == 2);
	}
}
