package gov.va.med.esr.voa.validator;

import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.util.AbstractCommonTestCase;
import gov.va.med.esr.voa.webservice.MilitaryServiceEpisodeInfo;
import gov.va.med.esr.voa.webservice.ObjectFactory;

import org.springframework.validation.BindException;

public class MilitaryServiceEpisodeInfoValidatorTest extends
		AbstractCommonTestCase {

	private MilitaryServiceEpisodeInfoValidator validator;

	private MilitaryServiceEpisodeInfo militaryServiceEpisodeInfo;

	@Override
	public void onSetUpInTransaction() throws Exception {
		super.onSetUpInTransaction();
		validator = new MilitaryServiceEpisodeInfoValidator();
		validator.setLookupService(getLookupService());

		ObjectFactory factory = new ObjectFactory();
		militaryServiceEpisodeInfo = factory.createMilitaryServiceEpisodeInfo();

		militaryServiceEpisodeInfo.setDischargeType(DischargeType.CODE_GENERAL
				.getCode());
		militaryServiceEpisodeInfo.setEndDate("01/01/1977");
		militaryServiceEpisodeInfo
				.setServiceBranch(ServiceBranch.CODE_AIR_FORCE.getCode());
		militaryServiceEpisodeInfo.setServiceNumber("01234");
		militaryServiceEpisodeInfo.setStartDate("01/01/1975");
	}

	@Override
	public void onTearDownInTransaction() {
		validator = null;
		militaryServiceEpisodeInfo = null;
		super.onTearDownInTransaction();
	}

	public void testMilitaryServiceEpisodeInfo() throws Exception {
		BindException errors = new BindException(militaryServiceEpisodeInfo,
				"militaryServiceEpisodeInfo");
		validator.validate(militaryServiceEpisodeInfo, errors);

		assertFalse(errors.hasErrors());
	}

	public void testServiceBranch() throws Exception {
		militaryServiceEpisodeInfo.setServiceBranch(null);
		BindException errors = new BindException(militaryServiceEpisodeInfo,
				"militaryServiceEpisodeInfo");
		validator.validate(militaryServiceEpisodeInfo, errors);

		assertEquals(1, errors.getErrorCount());

		militaryServiceEpisodeInfo.setServiceBranch("9999999999");
		errors = new BindException(militaryServiceEpisodeInfo,
				"militaryServiceEpisodeInfo");
		validator.validate(militaryServiceEpisodeInfo, errors);

		assertEquals(1, errors.getErrorCount());
	}

	public void testStartDate() throws Exception {
		militaryServiceEpisodeInfo.setStartDate(null);
		BindException errors = new BindException(militaryServiceEpisodeInfo,
				"militaryServiceEpisodeInfo");
		validator.validate(militaryServiceEpisodeInfo, errors);

		assertEquals(1, errors.getErrorCount());

		militaryServiceEpisodeInfo.setStartDate("012343");
		errors = new BindException(militaryServiceEpisodeInfo,
				"militaryServiceEpisodeInfo");
		validator.validate(militaryServiceEpisodeInfo, errors);

		assertEquals(1, errors.getErrorCount());
	}

	public void testEndDate() throws Exception {
		militaryServiceEpisodeInfo.setEndDate(null);
		BindException errors = new BindException(militaryServiceEpisodeInfo,
				"militaryServiceEpisodeInfo");
		validator.validate(militaryServiceEpisodeInfo, errors);

		assertEquals(1, errors.getErrorCount());

		militaryServiceEpisodeInfo.setEndDate("012343");
		errors = new BindException(militaryServiceEpisodeInfo,
				"militaryServiceEpisodeInfo");
		validator.validate(militaryServiceEpisodeInfo, errors);

		assertEquals(1, errors.getErrorCount());
	}

	public void testDischargeType() throws Exception {
		militaryServiceEpisodeInfo.setDischargeType(null);
		BindException errors = new BindException(militaryServiceEpisodeInfo,
				"militaryServiceEpisodeInfo");
		validator.validate(militaryServiceEpisodeInfo, errors);

		assertEquals(1, errors.getErrorCount());

		militaryServiceEpisodeInfo.setDischargeType("999999");
		errors = new BindException(militaryServiceEpisodeInfo,
				"militaryServiceEpisodeInfo");
		validator.validate(militaryServiceEpisodeInfo, errors);

		assertEquals(1, errors.getErrorCount());
	}

	public void testServiceNumber() throws Exception {
		militaryServiceEpisodeInfo.setServiceNumber(null);
		BindException errors = new BindException(militaryServiceEpisodeInfo,
				"militaryServiceEpisodeInfo");
		validator.validate(militaryServiceEpisodeInfo, errors);

		assertEquals(0, errors.getErrorCount());

		militaryServiceEpisodeInfo.setServiceNumber("999999324324234453");
		errors = new BindException(militaryServiceEpisodeInfo,
				"militaryServiceEpisodeInfo");
		validator.validate(militaryServiceEpisodeInfo, errors);

		assertEquals(1, errors.getErrorCount());
	}
}
