package gov.va.med.esr.voa.validator;

import gov.va.med.esr.common.model.lookup.MonetaryBenefitType;
import gov.va.med.esr.common.util.AbstractCommonTestCase;
import gov.va.med.esr.voa.common.ErrorCode;
import gov.va.med.esr.voa.webservice.EnrollmentDeterminationInfo;
import gov.va.med.esr.voa.webservice.MonetaryBenefitAwardInfo;
import gov.va.med.esr.voa.webservice.MonetaryBenefitCollection;
import gov.va.med.esr.voa.webservice.MonetaryBenefitInfo;
import gov.va.med.esr.voa.webservice.ObjectFactory;
import junit.framework.TestCase;

import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;

public class EnrollmentDeterminationInfoValidatorTest extends
		AbstractCommonTestCase {

	private EnrollmentDeterminationInfoValidator enrollmentDeterminationInfoValidator;

	@Override
	public void onSetUpInTransaction() throws Exception {
		super.onSetUpInTransaction();
		enrollmentDeterminationInfoValidator = new EnrollmentDeterminationInfoValidator();
		enrollmentDeterminationInfoValidator
				.setLookupService(getLookupService());
	}

	@Override
	public void onTearDownInTransaction() {
		enrollmentDeterminationInfoValidator = null;
		super.onTearDownInTransaction();
	}

	public void testValidEnrollmentDeterminationInfo() {
		ObjectFactory factory = new ObjectFactory();
		EnrollmentDeterminationInfo enrollmentDeterminationInfo = factory
				.createEnrollmentDeterminationInfo();
		MonetaryBenefitAwardInfo monetaryBenefitAwardInfo = factory
				.createMonetaryBenefitAwardInfo();
		enrollmentDeterminationInfo
				.setMonetaryBenefitAwardInfo(monetaryBenefitAwardInfo);

		MonetaryBenefitCollection monetaryBenefitCollection = factory
				.createMonetaryBenefitCollection();
		monetaryBenefitAwardInfo.setMonetaryBenefits(monetaryBenefitCollection);

		MonetaryBenefitInfo monetaryBenefitInfo = factory
				.createMonetaryBenefitInfo();
		monetaryBenefitCollection.getMonetaryBenefit().add(monetaryBenefitInfo);

		monetaryBenefitInfo.setType(MonetaryBenefitType.CODE_VA_PENSION
				.getCode());

		enrollmentDeterminationInfo.setEligibleForMedicaid(Boolean.TRUE);

		BindException errors = new BindException(enrollmentDeterminationInfo,
				"enrollmentDeterminationInfo");

		enrollmentDeterminationInfoValidator.validate(
				enrollmentDeterminationInfo, errors);

		TestCase.assertFalse(errors.hasErrors());
	}

	public void testValidEnrollmentDeterminationInfoNoType() {
		ObjectFactory factory = new ObjectFactory();
		EnrollmentDeterminationInfo enrollmentDeterminationInfo = factory
				.createEnrollmentDeterminationInfo();
		MonetaryBenefitAwardInfo monetaryBenefitAwardInfo = factory
				.createMonetaryBenefitAwardInfo();
		enrollmentDeterminationInfo
				.setMonetaryBenefitAwardInfo(monetaryBenefitAwardInfo);

		MonetaryBenefitCollection monetaryBenefitCollection = factory
				.createMonetaryBenefitCollection();
		monetaryBenefitAwardInfo.setMonetaryBenefits(monetaryBenefitCollection);

		MonetaryBenefitInfo monetaryBenefitInfo = factory
				.createMonetaryBenefitInfo();
		monetaryBenefitCollection.getMonetaryBenefit().add(monetaryBenefitInfo);

		monetaryBenefitInfo.setType(null);

		enrollmentDeterminationInfo.setEligibleForMedicaid(Boolean.TRUE);

		BindException errors = new BindException(enrollmentDeterminationInfo,
				"enrollmentDeterminationInfo");

		enrollmentDeterminationInfoValidator.validate(
				enrollmentDeterminationInfo, errors);

		TestCase.assertTrue(errors.getErrorCount() == 0);

		for (Object iter : errors.getAllErrors()) {
			ObjectError error = (ObjectError) iter;
			String code = error.getCode();

			assertEquals(ErrorCode.VOA_0088, code);
		}

		monetaryBenefitInfo.setType("invalid");

		errors = new BindException(enrollmentDeterminationInfo,
				"enrollmentDeterminationInfo");

		enrollmentDeterminationInfoValidator.validate(
				enrollmentDeterminationInfo, errors);

		for (Object iter : errors.getAllErrors()) {
			ObjectError error = (ObjectError) iter;
			String code = error.getCode();

			assertEquals(ErrorCode.VOA_0019, code);
		}

	}

	public void testValidEnrollmentDeterminationInfoWIthNullIndicator() {
		ObjectFactory factory = new ObjectFactory();
		EnrollmentDeterminationInfo enrollmentDeterminationInfo = factory
				.createEnrollmentDeterminationInfo();
		MonetaryBenefitAwardInfo monetaryBenefitAwardInfo = factory
				.createMonetaryBenefitAwardInfo();
		enrollmentDeterminationInfo
				.setMonetaryBenefitAwardInfo(monetaryBenefitAwardInfo);

		MonetaryBenefitCollection monetaryBenefitCollection = factory
				.createMonetaryBenefitCollection();
		monetaryBenefitAwardInfo.setMonetaryBenefits(monetaryBenefitCollection);

		MonetaryBenefitInfo monetaryBenefitInfo = factory
				.createMonetaryBenefitInfo();
		monetaryBenefitCollection.getMonetaryBenefit().add(monetaryBenefitInfo);

		monetaryBenefitInfo.setType(MonetaryBenefitType.CODE_VA_PENSION
				.getCode());

		enrollmentDeterminationInfo.setEligibleForMedicaid(null);

		BindException errors = new BindException(enrollmentDeterminationInfo,
				"enrollmentDeterminationInfo");

		enrollmentDeterminationInfoValidator.validate(
				enrollmentDeterminationInfo, errors);

		TestCase.assertTrue(errors.hasErrors());
	}

}
