package gov.va.med.esr.voa.validator;

import gov.va.med.esr.voa.webservice.EmailInfo;
import gov.va.med.esr.voa.webservice.ObjectFactory;
import junit.framework.TestCase;

import org.springframework.validation.BindException;

public class EmailInfoValidatorTest extends TestCase {

	private EmailInfoValidator emailInfoValidator;

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		this.emailInfoValidator = new EmailInfoValidator();
	}

	@Override
	protected void tearDown() throws Exception {
		super.tearDown();
		this.emailInfoValidator = null;
	}

	public void testValidEmail() {
		ObjectFactory factory = new ObjectFactory();
		EmailInfo emailInfo = factory.createEmailInfo();
		emailInfo.setAddress("ds232@hp.com");

		BindException errors = new BindException(emailInfo, "email");
		emailInfoValidator.validate(emailInfo, errors);

		TestCase.assertFalse(errors.hasErrors());
	}

	/**
	 * email with less than 3 digit numbers.
	 */
	public void testInValidEmail1() {
		ObjectFactory factory = new ObjectFactory();
		EmailInfo emailInfo = factory.createEmailInfo();
		emailInfo.setAddress("ds@hp.com");

		BindException errors = new BindException(emailInfo, "email");
		emailInfoValidator.validate(emailInfo, errors);

		TestCase.assertFalse(errors.hasErrors());
	}

	/**
	 * email start with @.
	 */
	public void testInValidEmail2() {
		ObjectFactory factory = new ObjectFactory();
		EmailInfo emailInfo = factory.createEmailInfo();
		emailInfo.setAddress("@hp.com");

		BindException errors = new BindException(emailInfo, "email");
		emailInfoValidator.validate(emailInfo, errors);

		TestCase.assertTrue(errors.hasErrors());
	}

	/**
	 * email end with @.
	 */
	public void testInValidEmail3() {
		ObjectFactory factory = new ObjectFactory();
		EmailInfo emailInfo = factory.createEmailInfo();
		emailInfo.setAddress("hp123@");

		BindException errors = new BindException(emailInfo, "email");
		emailInfoValidator.validate(emailInfo, errors);

		TestCase.assertTrue(errors.hasErrors());
	}

	/**
	 * email start with @.
	 */
	public void testInValidEmail4() {
		ObjectFactory factory = new ObjectFactory();
		EmailInfo emailInfo = factory.createEmailInfo();
		emailInfo.setAddress("@mytest1234@yahoo.com");
		
		BindException errors = new BindException(emailInfo, "email");
		emailInfoValidator.validate(emailInfo, errors);
		
		TestCase.assertTrue(errors.hasErrors());
	}
	
	/**
	 * email end with @.
	 */
	public void testInValidEmail5() {
		ObjectFactory factory = new ObjectFactory();
		EmailInfo emailInfo = factory.createEmailInfo();
		emailInfo.setAddress("mytest1234@yahoo.com@");
		
		BindException errors = new BindException(emailInfo, "email");
		emailInfoValidator.validate(emailInfo, errors);
		
		TestCase.assertTrue(errors.hasErrors());
	}
	
}
