package gov.va.med.esr.voa.util;

import junit.framework.TestCase;

public class ServiceUtilsTest extends TestCase {

	public void testYear() {
		String year = "1990";

		boolean isValid = ServiceUtils.isValidYear(year);

		if (isValid) {
			boolean futureYear = ServiceUtils.isFutureYear(year);
			assertFalse(futureYear);
		}

		year = "2020";
		isValid = ServiceUtils.isValidYear(year);

		if (isValid) {
			boolean futureYear = ServiceUtils.isFutureYear(year);
			assertTrue(futureYear);
		}
	}

	public void testMonthYear() {
		String monthYear = "01/1990";

		boolean isValid = ServiceUtils.isValidMonthYear(monthYear);

		if (isValid) {
			boolean futureYear = ServiceUtils.isFutureYear(monthYear);
			assertFalse(futureYear);
		}

		monthYear = "01/2020";

		isValid = ServiceUtils.isValidMonthYear(monthYear);

		if (isValid) {
			boolean futureYear = ServiceUtils.isFutureMonthYear(monthYear);
			assertTrue(futureYear);
		}
	}

	public void testSsn() {
		String ssn = "123456789";

		boolean isValid = ServiceUtils.validateSsn(ssn);
		assertTrue("ssn validation fails", isValid);

		ssn = "123546g";

		isValid = ServiceUtils.validateSsn(ssn);
		assertFalse("failed to valid ssn: " + ssn, isValid);

		ssn = "123abc4641";
		
		isValid = ServiceUtils.validateSsn(ssn);
		assertFalse("failed to valid ssn: " + ssn, isValid);
		
		ssn = "123";
		
		isValid = ServiceUtils.validateSsn(ssn);
		assertFalse("failed to valid ssn: " + ssn, isValid);

		ssn = " 123 ";
		
		isValid = ServiceUtils.validateSsn(ssn);
		assertFalse("failed to valid ssn: " + ssn, isValid);
		
		ssn = "#$";
		
		isValid = ServiceUtils.validateSsn(ssn);
		assertFalse("failed to valid ssn: " + ssn, isValid);
		
		ssn = "123-456-7890";
		
		isValid = ServiceUtils.validateSsn(ssn);
		assertFalse("failed to valid ssn: " + ssn, isValid);
	}
	
	public void phoneTest() {
		String phone = "1234567890";
		
		boolean isValid = ServiceUtils.validatePhoneWithExtension(phone);
		assertTrue("vadation of phone fails.", isValid);
		
		phone = "1234567890x1234";
		
		isValid = ServiceUtils.validatePhoneWithExtension(phone);
		assertTrue("vadation of phone fails.", isValid);
		
		phone = "1234567890xA22";
		
		isValid = ServiceUtils.validatePhoneWithExtension(phone);
		assertTrue("vadation of phone fails.", isValid);
		
		phone = "1234567890-A22";
		
		isValid = ServiceUtils.validatePhoneWithExtension(phone);
		assertTrue("vadation of phone fails.", isValid);
		
		phone = "A1234567890-A22";
		
		isValid = ServiceUtils.validatePhoneWithExtension(phone);
		assertFalse("Invadation of phone fails.", isValid);
		
		phone = "A1234567890$$A22";
		
		isValid = ServiceUtils.validatePhoneWithExtension(phone);
		assertFalse("Invadation of phone fails.", isValid);

		phone = "1234567890-A22#";
		
		isValid = ServiceUtils.validatePhoneWithExtension(phone);
		assertFalse("Invadation of phone fails.", isValid);
		
		phone = "12345";
		
		isValid = ServiceUtils.validatePhoneWithExtension(phone);
		assertFalse("Invadation of phone fails.", isValid);
		
		phone = "1234567890-A223333";
		
		isValid = ServiceUtils.validatePhoneWithExtension(phone);
		assertFalse("Invadation of phone fails.", isValid);
		
		phone = "1234567890+A223333";
		
		isValid = ServiceUtils.validatePhoneWithExtension(phone);
		assertFalse("Invadation of phone fails.", isValid);
		
		phone = "1234567890333333333";
		
		isValid = ServiceUtils.validatePhoneWithExtension(phone);
		assertFalse("Invadation of phone fails.", isValid);
	}

}
