/********************************************************************
 * Copyright  2004-2012 HP. All rights reserved
 ********************************************************************/
package gov.va.med.esr.voa.webservice.impl;

import java.math.BigInteger;

import gov.va.med.esr.voa.webservice.ObjectFactory;
import gov.va.med.esr.voa.webservice.RetrieveFormSubmissionStatusRequest;
import gov.va.med.esr.voa.webservice.RetrieveFormSubmissionStatusResponse;
import gov.va.med.esr.voa.webservice.SubmitFormRequest;
import gov.va.med.esr.voa.webservice.SubmitFormResponse;
import gov.va.med.esr.voa.webservice.VoaFault;
import gov.va.med.esr.voa.webservice.VoaFormServiceEndpoint;

/**
 * @author DNS   CHINNR
 *
 */

@javax.jws.WebService(endpointInterface = "gov.va.med.esr.voa.webservice.VoaFormServiceEndpoint")
// remove the schema validation because it breaks the deployment on some of the
// server.
// @SchemaValidation
public class VoaSvcPortImpl implements VoaFormServiceEndpoint {

	@Override
	public SubmitFormResponse saveSubmitForm(SubmitFormRequest submitFormRequest)
			throws VoaFault {

		final SubmitFormRequest request = submitFormRequest;
		ObjectFactory factory = new ObjectFactory();
		SubmitFormResponse response = factory.createSubmitFormResponse();
		final VOAESRService voaesrService = new VOAESRServiceImpl();
		voaesrService.saveVOAForm(submitFormRequest, response);
		final BigInteger appId = response.getFormSubmissionId();

		//run the full determination processing on separate thread
		//so we can return the submission id right away after it's saved
		Thread processSubmit = new Thread(){
	        public void run(){
				voaesrService.processVOAForm(request, appId);
	        }
	    };
	    processSubmit.start();


		return response;
	}

	@Override
	public RetrieveFormSubmissionStatusResponse getFormSubmissionStatus(
			RetrieveFormSubmissionStatusRequest retrieveFormSubmissionStatusRequest)
			throws VoaFault {
		ObjectFactory factory = new ObjectFactory();
		RetrieveFormSubmissionStatusResponse response = factory
				.createRetrieveFormSubmissionStatusResponse();
		VOAESRService voaesrService = new VOAESRServiceImpl();
		voaesrService.getVOAFormSubmissionStatus(
				retrieveFormSubmissionStatusRequest, response);
		return response;
	}

}
