/**
 *
 */
package gov.va.med.esr.voa.webservice.builder.impl;

import java.util.Calendar;
import java.util.Date;

import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.ApplicationMethod;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.AuthenticationLevel;
import gov.va.med.esr.common.model.lookup.BenefitType;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.lookup.DeathDataSource;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.EligibilityDocType;
import gov.va.med.esr.common.model.lookup.EmailType;
import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.common.model.lookup.EthnicityType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.lookup.InsurancePlanType;
import gov.va.med.esr.common.model.lookup.MaritalStatus;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.RaceType;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.lookup.Religion;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.lookup.SpinalCordInjuryType;
import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VAFacilityType;
import gov.va.med.esr.common.model.lookup.VOAApplicationStatus;
import gov.va.med.esr.common.model.lookup.VOAFormType;
import gov.va.med.esr.common.model.lookup.VeteranIdentifierType;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.config.SingletonApplicationContext;


/**
 * @author DNS   CHINNR
 *
 */
public class TypesHelper extends AbstractComponent{
	//
	private LookupService lookupService = null;

	public VeteranIdentifierType getVeteranIdentifierType(String vetType) {
		try {
			return (VeteranIdentifierType) this.getLookupService()
					.getVeteranIdentifierTypeByCode(vetType);
		} catch (Exception ex) {

		  if (logger.isDebugEnabled()){

			logger.debug(" Type Mapping Error: VeteranIdentifierType " + ex.getMessage());
		  }
		}
		return null;
	}

	public NameType getNameType(String nameType) {
		try {
			return (NameType) this.getLookupService().getNameTypeByCode(nameType);

		} catch (Exception ex) {
			 if (logger.isDebugEnabled()){
			     logger.debug(" Type Mapping Error: getNameType " +ex.getMessage());
			 }
		}
		return null;
	}

	public SSNType getSSNType(String ssnType) {
		try {
			return (SSNType) this.getLookupService().getSSNTypeByCode(ssnType);

		} catch (Exception ex) {
			 if (logger.isDebugEnabled()){
				 logger.debug(" Type Mapping Error: getSSNType " +ex.getMessage());
			 }
		}
		return null;
	}

	public InsurancePlanType getInsurancePlanType(String planType) {
		try {
			return (InsurancePlanType) this.getLookupService().getInsurancePlanTypeByCode(planType);

		} catch (Exception ex) {
			 if (logger.isDebugEnabled()){
				 logger.debug(" Type Mapping Error: InsurancePlanType " + ex.getMessage());
			 }
		}
		return null;
	}


	public AuthenticationLevel getAuthenticationLevel(String authLevel) {
		try {
			return (AuthenticationLevel) this.getLookupService()
					.getAuthenticationLevelByCode(authLevel);
		} catch (Exception ex) {
			 if (logger.isDebugEnabled()){
				 logger.debug(" Type Mapping Error: AuthenticationLevel " +ex.getMessage());
			 }
		}
		return null;
	}
	public State getState(String state) {
		try {
			return (State) this.getLookupService().getStateByCode(state);

		} catch (Exception ex) {
			 if (logger.isDebugEnabled()){
				 logger.debug(" Type Mapping Error: State " + ex.getMessage());
			 }
		}
			return null;
	}
	public Country getCountry(String country) {
			try {
				return (Country) this.getLookupService().getCountryByCode(country);
			} catch (Exception ex) {
				 if (logger.isDebugEnabled()){
					 logger.debug(" Type Mapping Error: Country " +ex.getMessage());
				 }
			}
			return null;
		}

  public DeathDataSource getDeathDataSource(String ddata) {
			try {
				return (DeathDataSource)this.getLookupService().getDeathDataSourceByCode(ddata);
			} catch (Exception ex) {
				 if (logger.isDebugEnabled()){
					 logger.debug(" Type Mapping Error: DeathDataSource " +ex.getMessage());
				 }
			}
			return null;
		}
	public ApplicationMethod getApplicationMethod(String appMethod) {
		try {
			return (ApplicationMethod) this.getLookupService()
					.getApplicationMethodByCode(appMethod);
		} catch (Exception ex) {
			 if (logger.isDebugEnabled()){
				 logger.debug(" Type Mapping Error: ApplicationMethod " +ex.getMessage());
			 }
		}
		return null;
	}

	public EligibilityDocType getEligibilityDocType(String docType){
		try{
			return (EligibilityDocType)this.getLookupService().getEligibilityDocTypeByCode(docType);
		}catch(Exception ex){
			 if (logger.isDebugEnabled()){
				 logger.debug(" Type Mapping Error: EligibilityDocType "+ex.getMessage());
			 }
		}
		return null;
	}
	public BenefitType getBenefitType(String benefitType) {
		try {
			return (BenefitType) this.getLookupService().getBenefitTypeByCode(
					benefitType);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: BenefitType " + ex.getMessage());
		}
		return null;
	}

	public VOAFormType getVOAFormType(String formType) {

		try {
			return (VOAFormType) this.lookupService
					.getVOAFormTypeByCode(formType);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: VOAFormType "+ex.getMessage());
		}
		return null;
	}

	public VAFacilityType getVAFacilityType(String facType) {

		try {
			return (VAFacilityType) this.getLookupService()
					.getVaFacilityTypeByCode(facType);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: VAFacilityType "+ex.getMessage());
		}
		return null;
	}
	public VOAApplicationStatus getVOAApplicationStatus(String appStatus) {

		try {
			return (VOAApplicationStatus) this.getLookupService().getVOAApplicationStatusByCode(appStatus);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: VOAApplicationStatus " +ex.getMessage());
		}
		return null;
	}

	public Religion getReligion(String religion) {

		try {
			return (Religion) this.getLookupService().getReligionByCode(religion);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: Religion " + ex.getMessage());
		}
		return null;
	}

	public VAFacility getVAFacility(String stationNumber) {

		try {
			return (VAFacility) this.getLookupService()
					.getVaFacilityByStationNumber(stationNumber);

		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: VAFacility " +ex.getMessage());
		}

		return null;
	}


	//RTC Task 236652  - added to handle code when veteran selects No to the disclose financial
	//details option in the VOA Form
	public IncomeTestSource getIncomeTestSource(String code) {

		try {
			return (IncomeTestSource ) this.getLookupService().getIncomeTestSourceByCode(code);

		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: IncomeTestSource " + ex.getMessage());
		}

		return null;
	}


	//RTC Task 236652  - added to handle code when veteran selects No to the disclose
	//financial details from the VOA UI
	public IncomeTestType getIncomeTestType(String code) {

		try {
			return (IncomeTestType) this.getLookupService().getIncomeTestTypeByCode(code);

		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: IncomeTestType " + ex.getMessage());
		}

		return null;
	}



	public Gender getGender(String gender) {
		try {
			return (Gender) (this.getLookupService().getGenderByCode(gender));
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: Gender " +ex.getMessage());
		}
		return null;
	}

	public Relationship getRelationship(String relation) {
		try {
			return (Relationship) this.getLookupService()
					.getRelationshipByCode(relation);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: Relationship "+ ex.getMessage());
		}
		return null;
	}

	public EmploymentStatus getEmploymentStatus(String empStatus) {
		try {
			return (EmploymentStatus) this.getLookupService()
					.getEmploymentStatusByCode(empStatus);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: EmploymentStatus "+ex.getMessage());
		}
		return null;
	}

	public AssociationType getAssociationType(String assoctype) {
		try {
			return (AssociationType) this.getLookupService()
					.getAssociationTypeByCode(assoctype);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: AssociationType "+ex.getMessage());
		}
		return null;
	}

	public AddressType getAddressType(String addType) {
		try {
			return (AddressType) this.getLookupService().getAddressTypeByCode(
					addType);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: AddressType "+ex.getMessage());
		}
		return null;
	}

	public PhoneType getPhoneType(String ptype) {
		try {
			return (PhoneType) this.getLookupService()
					.getPhoneTypeByCode(ptype);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: PhoneType " +ex.getMessage());
		}
		return null;
	}

	public EmailType getEmailType(String etype) {
		try {
			return (EmailType) this.getLookupService()
					.getEmailTypeByCode(etype);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: EmailType " +ex.getMessage());
		}
		return null;
	}

	public IncomeType getIncomeType(String incomeType) {
		if (incomeType != null) {
			try {
				return (IncomeType) this.getLookupService()
						.getIncomeTypeByCode(incomeType);
			} catch (Exception ex) {
				logger.debug(" Type Mapping Error: IncomeType "+ex.getMessage());
			}
		}
		return null;
	}

	public AssetType getAssetType(String assetType) {
		try {
			return (AssetType) this.getLookupService().getAssetTypeByCode(
					assetType);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: AssetType "+ex.getMessage());
		}
		return null;
	}

	public ExpenseType getExpenseType(String expenseType) {
		try {
			return (ExpenseType) this.getLookupService().getExpenseTypeByCode(
					expenseType);

		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: ExpenseType " +ex.getMessage());
		}
		return null;
	}

	public SSAVerificationStatus getSsaVerificationStatus(String ssa) {
		try {
			return (SSAVerificationStatus) this.getLookupService()
					.getSSAVerificationStatusByCode(ssa);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: SSAVerificationStatus " +ex.getMessage());
		}
		return null;
	}

	public MaritalStatus getMaritalStatus(String mstatus) {

		try {
			return (MaritalStatus) this.getLookupService()
					.getMaritalStatusByCode(mstatus);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: MaritalStatus " +ex.getMessage());
		}
		return null;
	}

	public EthnicityType getEthnicityType(String etype) {
		try {
			return (EthnicityType) this.getLookupService()
					.getEthnicityTypeByCode(etype);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: EthnicityType " +ex.getMessage());
		}
		return null;
	}

	public RaceType getRaceType(String racestring) {
		try {
			return (RaceType) this.getLookupService().getRaceTypeByCode(
					racestring);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: RaceType " +ex.getMessage());
		}
		return null;
	}

	public ServicePeriod getServicePeriod(String svcPeriod) {
		try {
			return (ServicePeriod) this.getLookupService()
					.getServicePeriodByCode(svcPeriod);

		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: ServicePeriod " +ex.getMessage());
		} // try
		return null;
	}

	public DischargeType getDischargeType(String dischargeType) {
		try {

			return (DischargeType) this.getLookupService()
					.getDischargeTypeByCode(dischargeType);
		} catch (Exception ex) {
			logger.debug(" Type Mappring Error: DischargeType "+ ex.getMessage());
		}
		return null;
	}

	public ServiceBranch getServiceBranch(String svcbranch) {
		// Service Branch
		try {
			return ((ServiceBranch) this.getLookupService()
					.getServiceBranchByCode(svcbranch));

		} catch (Exception ex) {
			logger.debug(" Type Mappring Error: ServiceBranch " + ex.getMessage());
		}
		return null;
	}

	public ConflictLocation getConflictLocation(String conflict) {
		try {
			return ((ConflictLocation) this.getLookupService()
					.getConflictByCode(conflict));

		} catch (Exception ex) {
			logger.debug(" Type Mappring Error: ConflictLocation "+ex.getMessage());
		} // try
		return null;
	}

	public DecorationStatus getDecorationStatus(String decorationStatus) {
		try {
			return (DecorationStatus) this.getLookupService()
					.getDecorationStatusByCode(decorationStatus);
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: DecorationStatus "+ ex.getMessage());
		}
		return null;
	}

	public SpinalCordInjuryType getSpinalCordInjuryType(String spinType) {
		try {
			// sc.setDeterminationFacility(arg0);
			return ((SpinalCordInjuryType) this.getLookupService()
					.getSpinalCordInjuryTypeByCode(spinType));
		} catch (Exception ex) {
			logger.debug(" Type Mapping Error: SpinalCordInjuryType " + ex.getMessage());
		}
		//
		return null;
	}


	public Integer getIncomeYear(){
		//The income year is current year -1 not fiscal year
	    Integer incomeYear = null;
	    Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        incomeYear = new Integer(calendar.get(Calendar.YEAR)-1);
        return incomeYear;

	}
	public LookupService getLookupService() {

		if (lookupService == null) {
			lookupService = (LookupService) SingletonApplicationContext
					.getInstance().getSingletonContext().getBean(
							"lookupService");
		}
		return lookupService;
	}

	public void setLookupService(LookupService lookupService) {
		this.lookupService = lookupService;
	}
}
