/**
 *
 */
package gov.va.med.esr.voa.webservice.builder.impl;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.voa.webservice.CombatEpisodeInfo;
import gov.va.med.esr.voa.webservice.ConflictExperienceInfo;
import gov.va.med.esr.voa.webservice.MilitaryServiceEpisodeInfo;
import gov.va.med.esr.voa.webservice.MilitaryServiceInfo;
import gov.va.med.esr.voa.webservice.MilitaryServiceSiteRecordInfo;
import gov.va.med.esr.voa.webservice.PrisonerOfWarInfo;
import gov.va.med.esr.voa.webservice.PurpleHeartInfo;
import gov.va.med.esr.voa.webservice.SubmitFormRequest;
import gov.va.med.esr.voa.webservice.builder.MilitaryServiceBuilderFactory;
import gov.va.med.fw.service.config.SingletonApplicationContext;

/**
 * @author DNS   CHINNR
 *
 */
public class MilitaryServiceBuilderFactoryImpl implements MilitaryServiceBuilderFactory {
	private LookupService lookupService = null;
	private TypesHelper typesHelper = new TypesHelper();
	public void buildMilitaryServices(Person person,SubmitFormRequest submitFormRequest) throws Exception{
		if(submitFormRequest.getForm().getSummary().getMilitaryServiceInfo() != null){
		MilitaryService militaryService = person.getMilitaryService();
		if(militaryService == null) militaryService = new MilitaryService();

		MilitaryServiceInfo msInfo = submitFormRequest.getForm().getSummary().getMilitaryServiceInfo();
		if(msInfo != null){

			if(msInfo.isDisabilityRetirementIndicator() != null)
				militaryService.setDisabilityRetirementIndicator(msInfo.isDisabilityRetirementIndicator());
			if(msInfo.isDischargeDueToDisability() != null)
				militaryService.setDischargeDueToDisability(msInfo.isDischargeDueToDisability());

			if(msInfo.getCombatEpisodes() != null && msInfo.getCombatEpisodes().getCombatEpisode() != null){

		    	getCombatEpisodes(msInfo.getCombatEpisodes().getCombatEpisode(),militaryService);

		    }

		    if(msInfo.getMilitaryServiceSiteRecords() != null && msInfo.getMilitaryServiceSiteRecords().getMilitaryServiceSiteRecord() != null){
		    	getMilitaryService(msInfo.getMilitaryServiceSiteRecords().getMilitaryServiceSiteRecord(),militaryService);
		    }
		    person.setMilitaryService(militaryService);
		}
		}
		//POW
		if(submitFormRequest.getForm().getSummary().getPrisonerOfWarInfo() != null){
			getPOWInfo(person,submitFormRequest);
		}
		//purple heat
		if(submitFormRequest.getForm().getSummary().getPurpleHeart() != null){
			getPurpleHeartInfo(person,submitFormRequest);
		}


	}

	private void getCombatEpisodes(List<CombatEpisodeInfo> combatList,MilitaryService militaryService){

		if(combatList != null){
			Iterator ceIter = combatList.iterator();
			while (ceIter.hasNext()) {
				CombatEpisodeInfo combatInfo = (CombatEpisodeInfo)ceIter.next();
				CombatEpisode ce = new CombatEpisode();
				if(combatInfo.getEndDate() != null && !combatInfo.getEndDate().isEmpty())ce.setEndDate(new ImpreciseDate(combatInfo.getEndDate()));
				if(combatInfo.getStartDate() != null && !combatInfo.getStartDate().isEmpty())ce.setStartDate(new ImpreciseDate(combatInfo.getStartDate()));
				militaryService.addCombatEpisode(ce);

			}
		}

	}

	private MilitaryService getMilitaryService(List<MilitaryServiceSiteRecordInfo> msList,MilitaryService militaryService){
		if(msList != null){

			for (Iterator iter = msList.iterator(); iter.hasNext();) {
				MilitaryServiceSiteRecordInfo mrInfo = (MilitaryServiceSiteRecordInfo) iter.next();
				MilitaryServiceSiteRecord mr = new MilitaryServiceSiteRecord();

				if(mrInfo.getSite() != null){
					mr.setSite(typesHelper.getVAFacility(mrInfo.getSite()));

				}
				 // service record
				if(mrInfo.getServicePeriod() != null){
					mr.setServicePeriod(typesHelper.getServicePeriod(mrInfo.getServicePeriod()));

				}  // service period

				// Military service episodes
				if(mrInfo.getMilitaryServiceEpisodes() != null && mrInfo.getMilitaryServiceEpisodes().getMilitaryServiceEpisode() != null){
					getMSEpisodes(mrInfo.getMilitaryServiceEpisodes().getMilitaryServiceEpisode(),mr);

				}

				//conflict experiences
				if(mrInfo.getConflictExperiences() != null && mrInfo.getConflictExperiences().getConflictExperience() != null){

					getConflictExperiences(mrInfo.getConflictExperiences().getConflictExperience(),mr);

				}

				if(mr != null) militaryService.addMilitaryServiceSiteRecord(mr);
			}

		}
		return militaryService;
	}

	private void getMSEpisodes(List<MilitaryServiceEpisodeInfo> mseList,MilitaryServiceSiteRecord mr){

		for (Iterator iter = mseList.iterator(); iter.hasNext();) {
			MilitaryServiceEpisodeInfo mseInfo = (MilitaryServiceEpisodeInfo) iter.next();
			MilitaryServiceEpisode mse = new MilitaryServiceEpisode();

			if(mseInfo.getDischargeType() != null)mse.setDischargeType(typesHelper.getDischargeType(mseInfo.getDischargeType()));
			if(mseInfo.getServiceBranch() != null)mse.setServiceBranch(typesHelper.getServiceBranch(mseInfo.getServiceBranch()));
			if(mseInfo.getStartDate() != null && !mseInfo.getStartDate().isEmpty())mse.setStartDate(new ImpreciseDate(mseInfo.getStartDate()));
			if(mseInfo.getEndDate() != null && !mseInfo.getEndDate().isEmpty())mse.setEndDate(new ImpreciseDate(mseInfo.getEndDate()));

			mr.addMilitaryServiceEpisode(mse);
		}

	}

	private void getConflictExperiences(List<ConflictExperienceInfo> confList,MilitaryServiceSiteRecord mr){

		for (Iterator iter = confList.iterator(); iter.hasNext();) {
			ConflictExperienceInfo confInfo = (ConflictExperienceInfo) iter.next();
			ConflictExperience conflict = new ConflictExperience();

			if(confInfo.getStartDate() != null && !confInfo.getStartDate().isEmpty())conflict.setStartDate(new ImpreciseDate(confInfo.getStartDate()));
			if(confInfo.getEndDate() != null && !confInfo.getEndDate().isEmpty())conflict.setEndDate(new ImpreciseDate(confInfo.getEndDate()));
			if(confInfo.getConflictLocation() != null){
				conflict.setConflictLocation(typesHelper.getConflictLocation(confInfo.getConflictLocation()));
			}//if
			mr.addConflictExperience(conflict);

		}

	}

	private void getPOWInfo(Person person,SubmitFormRequest submitFormRequest) throws Exception {
		PrisonerOfWar pow = person.getPrisonerOfWar();

		if (pow == null) pow = new PrisonerOfWar();

		PrisonerOfWarInfo powInfo = submitFormRequest.getForm().getSummary().getPrisonerOfWarInfo();
		if(powInfo.getPowIndicator() != null){
			try{
				if(powInfo.getPowIndicator() != null && powInfo.getPowIndicator().equalsIgnoreCase("true")){
					pow.setPowIndicator((Indicator)this.getLookupService().getIndicatorByCode(Indicator.YES));
				}else{
					pow.setPowIndicator((Indicator)this.getLookupService().getIndicatorByCode(Indicator.NO));
				}
				if(powInfo.getPowIndicator() == null){
					pow.setPowIndicator((Indicator)this.getLookupService().getIndicatorByCode(Indicator.UNKNOWN));
				}
			}catch(Exception ex){
				throw new Exception (ex);
			}
		}

		person.setPrisonerOfWar(pow);
	}

	private void getPurpleHeartInfo(Person person,SubmitFormRequest submitFormRequest) {
		PurpleHeart ph = person.getPurpleHeart();

		if (ph == null) ph = new PurpleHeart();

		PurpleHeartInfo phInfo = submitFormRequest.getForm().getSummary().getPurpleHeart();

		if(phInfo.isIndicator() != null && phInfo.isIndicator()) {
			ph.setPhIndicator(Boolean.TRUE);
		}else{
			ph.setPhIndicator(Boolean.FALSE);
		}

		person.setPurpleHeart(ph);

	}

	private Date getDateXMLtoJava(javax.xml.datatype.XMLGregorianCalendar xdate) {
		Date date = null;
		if (xdate != null) {
			date = new Date(xdate.getMillisecond());
		}

		return date;
	}


public LookupService getLookupService() {

		if(lookupService == null){
			lookupService= (LookupService) SingletonApplicationContext.getInstance().getSingletonContext()
			.getBean("lookupService");
		}
		return lookupService;
	}

	public void setLookupService(LookupService lookupService) {
		this.lookupService = lookupService;
	}

}
