/**
 *
 */
package gov.va.med.esr.voa.webservice.builder.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.datatype.DatatypeFactory;

import org.apache.commons.codec.binary.Base64;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.voa.webservice.AddressInfo;
import gov.va.med.esr.voa.webservice.AssetInfo;
import gov.va.med.esr.voa.webservice.EmploymentInfo;
import gov.va.med.esr.voa.webservice.ExpenseInfo;
import gov.va.med.esr.voa.webservice.IncomeInfo;
import gov.va.med.fw.service.AbstractComponent;

/**
 * @author DNS   CHINNR
 *
 */
public class BuildHelper extends AbstractComponent{
	 private TypesHelper typesHelper = new TypesHelper();

	public  Address buildAddressInfo(AddressInfo addressInfo) {

		Address address = new Address();
		if(addressInfo.getLine1() != null) address.setLine1(addressInfo.getLine1());
		if(addressInfo.getLine2() != null)address.setLine2(addressInfo.getLine2());
		if(addressInfo.getLine3() != null)address.setLine3(addressInfo.getLine3());
		if(addressInfo.getPostalCode() != null)address.setPostalCode(addressInfo.getPostalCode());
		if(addressInfo.getZipCode() != null)address.setZipCode(addressInfo.getZipCode());
		if(addressInfo.getZipPlus4() != null)address.setZipPlus4(addressInfo.getZipPlus4());
		if(addressInfo.getCity() != null)address.setCity(addressInfo.getCity());
		if(addressInfo.getState() != null)address.setState(addressInfo.getState());
		if(addressInfo.getCounty() != null) address.setCounty(addressInfo.getCounty());
		if(addressInfo.getCountry() != null)address.setCountry(addressInfo.getCountry());
		address.setChangeDate(new Date());




		if ( addressInfo.getAddressTypeCode() != null)
		{
			try {
			address.setType(this.typesHelper.getLookupService().getAddressTypeByCode(AddressType.CODE_PERMANENT_ADDRESS.getCode()));
			} catch (Exception ex) {
				logger.error("Cannot lookup address type:", ex);
			}
		}

		if(addressInfo.getPhoneNumber() != null) {
			address.setPhoneNumber(addressInfo.getPhoneNumber());
		}

		return address;
	}
	public  Employment buildEmployment(EmploymentInfo employmentInfo) {


		Employment employment = new Employment();

		if(employmentInfo.getEmployerName() != null) {
			employment.setEmployerName(employmentInfo.getEmployerName());
		}

		if(employmentInfo.getEmployerPhone() != null)	{
			employment.setEmployerPhone(employmentInfo.getEmployerPhone());
		}
			//employment status

		if(employmentInfo.getEmploymentStatus() != null) {
			employment.setEmploymentStatus(typesHelper.getEmploymentStatus(employmentInfo.getEmploymentStatus()));
		}

		if(employmentInfo.getRetirementDate() != null && !employmentInfo.getRetirementDate().isEmpty()){

			employment.setRetirementDate(new ImpreciseDate(employmentInfo.getRetirementDate()));
	     }

		if(employmentInfo.getEmployerAddress() != null) {
	        AddressInfo empAddress = employmentInfo.getEmployerAddress();
			employment.setEmployerAddress(buildAddressInfo(empAddress));
		}

		return employment;
	}

	public Asset buildAssetInfo(AssetInfo assetInfo) {

	Asset asset = new Asset();
		if(assetInfo.getAmount() != null) asset.setAmount(assetInfo.getAmount());
		return asset;
	}

	public Income buildIncomeInfo(IncomeInfo incomeInfo){

		Income income = new Income();

		if(incomeInfo.getAmount() != null) {
			income.setAmount(incomeInfo.getAmount());
		}

		return income;
	}

	public Expense buildExpenseInfo(ExpenseInfo expenseInfo){
		Expense expense = new Expense();

		if(expenseInfo.getAmount() != null) {
			expense.setAmount(expenseInfo.getAmount());
		}
		 return expense;
	}

	public Date getDateXMLtoJava(XMLGregorianCalendar xdate) {
		Date date = null;

		if (xdate != null) {
			date = xdate.toGregorianCalendar().getTime();
		}

		return date;
	}

	public XMLGregorianCalendar getDateJavatoXML(Date date) {
		GregorianCalendar gc = new GregorianCalendar();
		gc.setTime(date);
		XMLGregorianCalendar mdate = null;
		try {
			DatatypeFactory df = null;
			df = DatatypeFactory.newInstance();
			mdate = df.newXMLGregorianCalendar(gc);
		} catch (Exception ex) {
			logger.error("Exception @getDateJavatoXML  :", ex);
		}
		return mdate;
	}

	public Date stringToDate(String string){
		Date date = null;
		try{
			SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
		    date = dateFormat.parse(string);

		} catch (Exception ex){

			logger.error("Exception @stringToDate  :", ex);
		}
		return  date;
	}

	public byte[] encodeContent(byte[] dcontent){

		byte [] content  = null;
			try{
				//encode and send
				content = Base64.encodeBase64(dcontent);
			}catch (Exception ex){
				logger.error("Exception @encodeContent  :", ex);
			}
		return content;

	}

	public byte[] decodeContent(byte[] content){

			try{
				//decode and write
				byte[]	decode = Base64.decodeBase64(content);
				return decode;
			}catch (Exception ex){
				ex.printStackTrace();
				logger.error("Exception @decodeContent  :", ex);
			}
		return null;
	}

}
