package gov.va.med.esr.voa.validator;

import gov.va.med.esr.voa.common.ErrorCode;
import gov.va.med.esr.voa.webservice.EnrollmentDeterminationInfo;

import org.springframework.validation.Errors;

/**
 * Validate Enrollment Determination information
 */
public class EnrollmentDeterminationInfoValidator extends AbstractValidator {

	@SuppressWarnings("rawtypes")
	@Override
	public boolean supports(Class clazz) {
		return EnrollmentDeterminationInfo.class.equals(clazz);
	}

	@Override
	public void validate(Object target, Errors errors) {
		logger.debug("Validate Enrollment Determination information.");

		if (target != null) {
			EnrollmentDeterminationInfo enrollmentDeterminationInfo = (EnrollmentDeterminationInfo) target;

			Boolean isEligibleForMedicaid = enrollmentDeterminationInfo
					.isEligibleForMedicaid();
			if (isEligibleForMedicaid == null) {
				errors.reject(ErrorCode.VOA_0068,
						"Missing Required Field: Medicaid eligibility.");
			}
		}

		logger.debug("Validate Enrollment Determination information - Done.");
	}

}
