package gov.va.med.esr.voa.validator;

import gov.va.med.esr.voa.common.ErrorCode;
import gov.va.med.esr.voa.webservice.EmailInfo;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.StringUtils;

import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

/**
 * Validate email address
 */
public class EmailInfoValidator extends AbstractComponent implements Validator {

	//return /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+

	@SuppressWarnings("rawtypes")
	@Override
	public boolean supports(Class clazz) {
		return EmailInfo.class.equals(clazz);
	}

	@Override
	public void validate(Object target, Errors errors) {

		if (target != null) {
			EmailInfo emailInfo = (EmailInfo) target;

			String emailAddress = emailInfo.getAddress();
			if (StringUtils.isNotBlank(emailAddress)) {
				int numberOfChars = emailAddress.length();
				if (numberOfChars < 3 || numberOfChars > 50) {
					errors.reject(ErrorCode.VOA_0036,
							"Invalid Veteran email address.");
					logger.debug("email address " + emailAddress
							+ " has less than 3 digits.");
				}
			}
		}

	}

}
