package gov.va.med.esr.voa.validator;

import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.config.SingletonApplicationContext;

import org.springframework.validation.Validator;

/**
 * Form validation
 */
public abstract class AbstractValidator extends AbstractComponent implements
		Validator {

	// Lookup service is used to valid the reference data. For example,
	// addressType.
	private LookupService lookupService;

	// the reference object used for validation.
	private Object reference;
	
	boolean isNewOMBApprovedForm = false;

	/**
	 * default constructor.
	 */
	public AbstractValidator() {
		this(null);
	}

	/*
	 * constructor, with reference parameter.
	 */
	public AbstractValidator(Object reference) {
		this.reference = reference;
	}

	/**
	 * get an instance of lookupService.
	 * 
	 * @return: instance of lookupService
	 */
	public LookupService getLookupService() {
		if (lookupService == null) {
			lookupService = (LookupService) SingletonApplicationContext
					.getInstance().getSingletonContext()
					.getBean("lookupService");
		}
		return lookupService;
	}

	public void setLookupService(LookupService lookupService) {
		this.lookupService = lookupService;
	}

	public Object getReference() {
		return reference;
	}

	public void setReference(Object reference) {
		this.reference = reference;
	}

	public boolean isNewOMBApprovedForm() {
		return isNewOMBApprovedForm;
	}

	public void setNewOMBApprovedForm(boolean isNewOMBApprovedForm) {
		this.isNewOMBApprovedForm = isNewOMBApprovedForm;
	}

}
