<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>

<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>
<%@ page import="gov.va.med.esr.common.model.lookup.CampLejeuneVerificationType" %>
<%@ page import="gov.va.med.esr.common.model.lookup.CampLejeuneChangeSource" %>
<%@ page import="gov.va.med.esr.common.model.lookup.VAFacility" %>
<c:set var="readOnlyMS" scope="request" value="true"/>

<!-- add/edit militray service are not differentiated -->
<auth:authorize ifAnyGranted="<%=Capability.ADD_MILITARY_SERVICE_INFO.getName()%>">
  <c:set var="readOnlyMS" scope="request" value="false"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.EDIT_MILITARY_SERVICE_INFO.getName()%>">
  <c:set var="readOnlyMS" scope="request" value="false"/>
</auth:authorize>

  <%-- Person Locked Check --%>
<c:set var="appData" value="${AppData}" scope="session"/>
<c:set var="personKey" value="SelectedPerson"/>
<c:set var="personLocked" value="${appData[personKey].personLocked}"/>
<c:if test="${personLocked}">
  <c:set var="readOnlyMS" scope="request" value="true"/>
</c:if>

<c:set var="CLVRequiredFields" scope="page" value="false" />
<c:choose>
<c:when test="${CLVRequiredFields}">
<c:set var="requiredFlag"><%= Boolean.TRUE.toString() %></c:set>
<c:set var="requiredText"><bean-el:message key="label.required"/>,&nbsp;</c:set>
</c:when>
<c:otherwise>
<c:set var="requiredFlag"><%= Boolean.FALSE.toString() %></c:set>
<c:set var="requiredText"></c:set>
</c:otherwise>
</c:choose>

<c:set var="isCampLejeuneDisabled" value="true"></c:set>
<c:if test="${militaryServiceInfoForm.campLejeuneDisabled == 'false' && !readOnlyMS}">
<c:set var="isCampLejeuneDisabled" value="false"></c:set>
</c:if>
 
<c:set var="IndicatorNO"><%=gov.va.med.esr.common.model.lookup.Indicator.NO.getCode()%></c:set>
<c:set var="IndicatorYES"><%=gov.va.med.esr.common.model.lookup.Indicator.YES.getCode()%></c:set>
<esrcore:setLookup var="SortedIndicator" className="gov.va.med.esr.ui.common.beans.SortedIndicator" />

<c:set var="mmddyyyyText" scope="page"><bean-el:message key="label.mmddyyyy"/></c:set>
<c:set var="expandableSectionCollapsed" scope="page"><bean-el:message key="label.expandableSectionCollapsed"/></c:set>
<c:set var="verificationmethod_other" scope="page"><%=CampLejeuneVerificationType.VERIFICATION_OTHER.getName()%></c:set>

<script type="text/javascript" language="JavaScript">

var methodCounter=0;


function processAddPerson(isAddPerson)
{
  var clv_n = document.getElementById('idclvInd_0');
  var clv_y = document.getElementById('idclvInd_1');
  if(isAddPerson!=null)
  {
   if(isAddPerson==true)
   {
   	clv_n.disabled=false;
	clv_y.disabled=false;
	document.getElementById('idCDate').style.display='none';
	document.getElementById('idCSource').style.display='none';
	document.getElementById('idCSite').style.display='none';
	processCLVIndicator();
	checkForOtherVerificationMethod();
    }
   }
}
function processCLVEligibility(isDisabled)
{
	var clv_n = document.getElementById('idclvInd_0');
 	var clv_y = document.getElementById('idclvInd_1');
 	var clvblock = document.getElementById('clvBlock');
 	 var clvimageElement = document.getElementById('rieArrowImage');
	if(isDisabled== true)
	{
		
		collapseSection(clvblock, clvimageElement, null);
		clv_n.disabled=true;
		clv_y.disabled=true;
		
	}
}

function processCLVIndicator()
{
 	var clv_n = document.getElementById('idclvInd_0');
 	var clv_y = document.getElementById('idclvInd_1');
    var clvblock = document.getElementById('clvBlock');
    var clvimageElement = document.getElementById('rieArrowImage');
    var verificationMethod = document.getElementById('idVerificationMethod');
	var comments = document.getElementById('idComments');
	var verificationMethods = "campLejeuneVerificationMethods";
			 var checkVerificationMethod = document.getElementById (verificationMethods).value;
	 
	
        if (clv_y.checked)
        {
        	expandSection(clvblock, clvimageElement, null);
        	verificationMethods.disabled=false;

        }
        else
        {
            collapseSection(clvblock, clvimageElement, null);
          	verificationMethods.disabled=true;
        }
}



















































	
function checkForNoVerificationMethods() {
	var checkSelected = false;
	if (methodCounter != 0)
	{
	for (i = 0; i < militaryServiceInfoForm.campLejeuneVerificationMethods.length; i++) {
		if (militaryServiceInfoForm.campLejeuneVerificationMethods[i].checked) {
			checkSelected = true;
		}
	}
		if (!checkSelected) {
			alert("Once any Camp Lejeune Verified Method has been selected, at least one must remain selected");
			return false;
		}
	}
	return true;
}


function countMethods() {
	var i = 0;
	for (i = 0; i < militaryServiceInfoForm.campLejeuneVerificationMethods.length; i++) {
		 if (militaryServiceInfoForm.campLejeuneVerificationMethods[i].checked) {
		 methodCounter++;
		 }
	}
}

</script>


<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
      <tr>
      		<td class="moduleLabel"><fw:label property="campLejeuneInd" forId="idCLV"><html-el:img alt="${expandableSectionCollapsed}" align="center" styleId="rieArrowImage" src="../images/redArrowRight.gif" /><bean-el:message key="label.clvInd" />:</fw:label></td>
      		<td width="50%" class="moduleValue">
      		        <c:set var="clvText"><bean-el:message key="label.clvInd"/></c:set>
      			<c:forEach var="item" items="${SortedIndicator}">
      			    <c:if test="${item.code == IndicatorNO or item.code == IndicatorYES}">
      				<html-el:radio title="${clvText} (${item.description})" name="militaryServiceInfoForm" property="campLejeuneInd" styleId="idclvInd_${item.code}" value="${item.code}" onclick="processCLVIndicator()" onKeyPress="processCLVIndicator()" disabled="${readOnlyMS}"/>
      				<fw:label property="campLejeuneInd" forId="idclvInd_${item.code}"><c:out value="${item.description}" />&nbsp;&nbsp;</fw:label>
      			    </c:if>
      			</c:forEach> 
      		</td>
	</tr>
</table> 

<table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">        
<tr>
    <td width="100%" colspan="2">
    <div id="clvBlock" class="expandCollapseBody">
    <table width="100%" cellSpacing="0" cellPadding="0" border="0" role="presentation">
  <td class="moduleLabel" style="vertical-align: top"><fw:label property="campLejeuneVerificationMethods" forId="campLejeuneVerificationMethodsTextId"><bean-el:message key="label.clVerificationMethods"/>:</fw:label></td>
  <td class="moduleValue">
    <esrcore:setLookup var="campLejeuneVerificationMethodsList" className="gov.va.med.esr.common.model.lookup.CampLejeuneVerificationType"/>
    <table border="0" cellpadding="0" cellspacing="0" role="presentation">
      <c:forEach var="item" items="${campLejeuneVerificationMethodsList}" varStatus="loopCounter">
        <c:set var="campLejeuneVerificationMethodsText"><bean-el:message key="label.clVerificationMethods"/>&nbsp;(<c:out value="${item.name}"/>)</c:set>
        <tr><td><html-el:multibox title="${campLejeuneVerificationMethodsText}" property="campLejeuneVerificationMethods" styleId="campLejeuneVerificationMethodsTextId${loopCounter.count}" value="${item.code}" onclick="checkForOtherVerificationMethod(); return(checkForNoVerificationMethods())" disabled="${isCampLejeuneDiabled}" /></td><td class="moduleValue" width="99%"><c:out value="${item.name}"/></td>
        </tr>
      </c:forEach>
    </table>
  </td> 
    <tr>
      <td width="50%" class="moduleLabel"><fw:label property="campLejeuneVerificationComments"><bean-el:message key="label.clvComments"/>:</fw:label></td>
      <td width="50%" class="moduleValue">
        <c:set var="clvCommentsText"><bean-el:message key="label.clvComments"/> </c:set>
        <html-el:text title="${clvCommentsText}" styleClass="moduleEdit" styleId="idComments" size="75" maxlength="200" disabled="${isCampLejeuneDiabled}" property="campLejeuneVerificationComments" />
      </td>
    </tr> 
    <tr id="idCDate">
       <td width="50%" class="moduleLabel"><fw:label property="campLejeuneChangeDate"><bean-el:message key="label.clvChangeDate"/>:</fw:label></td>
       <td width="50%" class="moduleValue">
         <c:set var="clvChangeDateText"><bean-el:message key="label.clvChangeDate"/> <bean-el:message key="label.mmddyyyy"/></c:set>
         <html-el:text title="${clvChangeDateText}" styleClass="moduleEdit" styleId="idChangeDate" disabled="${isCampLejeuneDiabled}" property="campLejeuneChangeDate" />&nbsp;<bean-el:message key="label.mmddyyyy"/>
       </td>
     </tr>
 
     <tr id="idCSite">
      <td width="50%" class="moduleLabel"><bean-el:message key="label.clvChangeSite"/>:</td>
      <td width="50%" class="moduleValue">
        <c:set var="changeSiteText"><bean-el:message key="label.clvChangeSite"/></c:set>
        <esrcore:displayValue name="militaryServiceInfoForm" property="campLejeuneChangeSite"/>      
      </td>
    </tr>
     <tr id="idCSource">
      <td width="50%" class="moduleLabel"><bean-el:message key="label.clvChangeSource"/>:</td>
      <td width="50%" class="moduleValue">
        <c:set var="changeSourceText"><bean-el:message key="label.clvChangeSource"/></c:set>
        <esrcore:displayValue name="militaryServiceInfoForm" property="campLejeuneChangeSource"/>               
      </td>
    </tr>   
 </table>
 </div>
</td>
</tr>
</table>