<%@ page import="gov.va.med.esr.common.model.lookup.Capability"%>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>

<c:set var="editDemographicInfo" value="false"/>
<c:set var="editInsurance" value="false"/>
<auth:authorize ifAnyGranted="<%=Capability.EDIT_DEMOGRAPHIC_INFO.getName()%>">
  <c:set var="editDemographicInfo" value="true"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.UPDATE_INSURANCE%>">
  <c:set var="editInsurance" value="true"/>
</auth:authorize>

<%-- Person Locked Check --%>
<c:set var="appData" value="${AppData}" scope="session"/>
<c:set var="personKey" value="SelectedPerson"/>
<c:set var="personLocked" value="${appData[personKey].personLocked}"/>
<c:if test="${personLocked}">
  <c:set var="editDemographicInfo" value="false"/>
  <c:set var="editInsurance" value="false"/>
</c:if>
 
<table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">
  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">

        <%-- Update Personal --%>
        <c:set var="updateAddress" value="false"/>
        <c:set var="viewDemographics" value="false"/>
        <auth:authorize ifAnyGranted="<%=Capability.UPDATE_ADDRESS%>">
          <c:set var="updateAddress" value="true"/>
        </auth:authorize>
        <auth:authorize ifAnyGranted="<%=Capability.DEMOGRAPHICS%>">
          <c:set var="viewDemographics" value="true"/>
        </auth:authorize>

        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
              <tr>
                <td>
                  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
                    <tr>
                      <td>
                        <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
                          <tr>
                            <td class="moduleBlueBox"><img alt="" src="../images/spacer.gif" width="25" height="17"/></td>
                            <td nowrap class="moduleHeadline">
                            <c:choose>
                            <c:when test="${editDemographicInfo == true}">
                              <a href="/esr/demographic/demographicPersonal.do?methodName=Personal"><bean-el:message key="text.updatePersonal"/></a>
                            </c:when>
                            <c:otherwise>
                              <bean-el:message key="text.updatePersonal"/>
                            </c:otherwise>
                            </c:choose>
                            </td>
                          </tr>
                        </table>
                      </td>
                    </tr>

                    <tr>
                      <td>
                        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody" role="presentation">
                        <auth:authorize ifAnyGranted="<%=Capability.PERSONAL%>">
                        <tr>
                          <td width="50%" class="darklabel"><bean-el:message key="label.personal.employmentStatus"/>:</td>
                          <td  width="50%" class="darkvalue"><esrcore:displayValue name="demographicOverviewForm" property="employmentStatus"/></td>
                        </tr>
                        <tr>
                          <td width="50%" class="label"><bean-el:message key="label.personal.dateOfDeathStatus"/>:</td>
                          <td width="50%" class="value"><esrcore:displayValue name="demographicOverviewForm" property="currentStatus"/></td>
                        </tr>
                        <tr>
                          <td width="50%" class="darklabel"><bean-el:message key="label.personal.preferredLanguage"/>:</td>
                          <td  width="50%" class="darkvalue"><esrcore:displayValue name="demographicOverviewForm" property="preferredLanguage"/></td>
                        </tr>
                        <tr>
                          <td width="50%" class="label"><bean-el:message key="label.emergencyResponse"/>:</td>
                          <td width="50%" class="value"><esrcore:displayValue name="demographicOverviewForm" property="emergencyResponse"/>
                          </td>
                        </tr>
                        </auth:authorize>
                        </table>
                      </td>
                    </tr>
                  </table>
                </td>
              </tr>
            </table>
          </td>
        </tr>

        <%-- Row spacing --%>
        <tr height="10"><td></td></tr>

        <%-- Update Insurance --%>
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell" role="presentation">
              <tr>
                <td>
                  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable" role="presentation">
                    <tr>
                      <td>
                        <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead" role="presentation">
                          <tr>
                            <td class="moduleBlueBox"><img alt="" src="../images/spacer.gif" width="25" height="17"/></td>
                            <td nowrap class="moduleHeadline">
                            <c:choose>
                            <c:when test="${editInsurance == true}">
                              <a href="/esr/demographic/insuranceInfoDisplay.do"><bean-el:message key="text.updateInsuranceLink"/></a>
                            </c:when>
                            <c:otherwise>
                              <bean-el:message key="text.updateInsuranceLink"/>
                            </c:otherwise>
                            </c:choose>
                            </td>
                          </tr>
                        </table>
                      </td>
                    </tr>

                    <tr>
                      <td>
                        <table summary="List of Insurances for the Person" width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
                          <c:choose>
                          <c:when test="${demographicOverviewForm.anyInsuranceCarriersPresent == true}">
                            <thead>
                            <tr>
                              <th scope="col" width="1%" class="darkValue">&nbsp;</th>
                              <th scope="col" width="10%" class="darkValue"><b><bean-el:message key="label.carrier"/></b></th>
                              <th scope="col" width="10%" class="darkValue"><b><bean-el:message key="menu.facility"/></b></th>
                              <th scope="col" width="10%" class="darkValue"><b><bean-el:message key="label.ins.groupname"/></b></th>
                              <th scope="col" width="1%" class="darkValue">&nbsp;</th>
                            </tr>
                            </thead>

                            <auth:authorize ifAnyGranted="<%=Capability.INSURANCE%>">
                            <c:set var="rowColor" value="darkValue"/>
                            <tbody>

                            <%-- Site Records --%>
                            <c:forEach var="insurance" items="${demographicOverviewForm.siteInsuraceCarriers}">
                              <c:choose>
                                <c:when test="${rowColor == 'darkValue'}">
                                  <c:set var="rowColor" value="value"/>
                                </c:when>
                                <c:otherwise>
                                  <c:set var="rowColor" value="darkValue"/>
                                </c:otherwise>
                              </c:choose>
                              <tr>
                                <td class="<c:out value='${rowColor}'/>">&nbsp;</td>
                                <td scope="row" valign="top" class="<c:out value="${rowColor}"/>" nowrap>
                                  <c:choose>
                                  <c:when test="${insurance.class.name == 'gov.va.med.esr.common.model.insurance.Medicare'}">
                                    <c:set var="insuranceName"><bean-el:message key="text.medicare"/></c:set>
                                  </c:when>
                                  <c:otherwise>
                                    <c:set var="insuranceName" value="${insurance.companyName}" />
                                  </c:otherwise>
                                  </c:choose>
                                  <c:out value="${insuranceName}"/>
                                </td>
                                <td valign="top" class="<c:out value='${rowColor}'/>">
                          				<c:set var="reportSiteName" value="${insurance.reportSite.name}" />
                          				<c:set var="reportSite" value="${insurance.reportSite.stationNumber}" />
                                  <c:out value="${reportSiteName}" /> (#<c:out value="${reportSite}" />)
                                </td>
                                <td valign="top" class="<c:out value="${rowColor}"/>">
                                  <c:if test="${not empty insurance.groupName}">
                                    <c:out value="${insurance.groupName}"/>
                                  </c:if>
                                </td>
                                <td class="<c:out value="${rowColor}"/>">&nbsp;</td>
                              </tr>
                            </c:forEach>

                            <%-- HEC Records --%>
                            <c:forEach var="insurance" items="${demographicOverviewForm.hecInsuraceCarriers}">
                              <c:choose>
                                <c:when test="${rowColor == 'darkValue'}">
                                  <c:set var="rowColor" value="value"/>
                                </c:when>
                                <c:otherwise>
                                  <c:set var="rowColor" value="darkValue"/>
                                </c:otherwise>
                              </c:choose>

                              <c:choose>
                              <c:when test="${insurance.class.name == 'gov.va.med.esr.common.model.insurance.Medicare'}">
                              <%-- Medicare Insurance --%>

                              <tr>
                                <td class="<c:out value='${rowColor}'/>">&nbsp;</td>
                                <td valign="top" class="<c:out value="${rowColor}"/>" nowrap>
                                  <c:choose>
                                    <c:when test="${editInsurance}">
                                      <fw:link action="/editMedicare?methodName=editMedicare">
                                        <bean-el:message key="text.medicare"/>
                                      </fw:link>
                                    </c:when>
                                    <c:otherwise>
                                      <bean-el:message key="text.medicare"/>
                                    </c:otherwise>
                                  </c:choose>
                                </td>
                                <td valign="top" class="<c:out value='${rowColor}'/>">
                                  <bean-el:message key="label.HEC"/>
                                </td>
                                <td valign="top" class="<c:out value="${rowColor}"/>">
                                  <c:choose>
                                    <c:when test="${((insurance.enrolledInPartB != null) && (insurance.enrolledInPartB))}">
                                      <bean-el:message key="label.ins.partAandB"/>
                                    </c:when>
                                    <c:otherwise>
                                      <bean-el:message key="label.ins.partA"/>
                                    </c:otherwise>
                                  </c:choose>
                                </td>
                                <td class="<c:out value="${rowColor}"/>">&nbsp;</td>
                              </tr>

                              </c:when>
                              <c:otherwise>
                              <%-- Private Insurance --%>
                              <tr>
                                <td class="<c:out value='${rowColor}'/>">&nbsp;</td>
                                <td valign="top" class="<c:out value="${rowColor}"/>" nowrap>
                                 <c:choose>
                      				<c:when test="${isAddAPerson}">
                      					<c:set var="identifier" value="InsuranceIDUNKNOWN" />
                      				</c:when>
                      				<c:otherwise>
                       					<c:set var="identifier" value="${insurance.entityKey.keyValueAsString}" />
                      				</c:otherwise>
                      			</c:choose>
                                  <c:set var="name" value="${insurance.companyName}" />
                                  <c:choose>
                                    <c:when test="${editInsurance && not isAddAPerson}">
                                      <fw:link action="editInsurance?methodName=DISPLAY" paramId="insuranceId" paramName="identifier"><c:out value="${name}" /></fw:link>
                                    </c:when>
                                    <c:otherwise>
                                      <c:out value="${name}" />
                                    </c:otherwise>
                                  </c:choose>
                                </td>
                                <td valign="top" class="<c:out value='${rowColor}'/>">
                                  <bean-el:message key="label.HEC"/>
                                </td>
                                <td valign="top" class="<c:out value="${rowColor}"/>">
                                  <c:if test="${not empty insurance.groupName}">
                                    <c:out value="${insurance.groupName}"/>
                                  </c:if>
                                </td>
                                <td class="<c:out value="${rowColor}"/>">&nbsp;</td>
                              </tr>

                              </c:otherwise>
                              </c:choose>
                            </c:forEach>

                            </tbody>
                            </auth:authorize>
                          </c:when>
                          <c:otherwise>
                          <tr>
                            <td class="value" style="text-align: center"><bean:message key="label.noDataAvailable"/></td>
                          <tr>
                          </c:otherwise>
                          </c:choose>
                        </table>
                      </td>
                    </tr>
                  </table>
                </td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>
		<html-el:hidden name="demographicOverviewForm" property="addAPerson"/>