<%@ taglib uri="http://struts.apache.org/tags-bean-el" prefix="bean-el"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el"%>
<%@ taglib uri="/tags/esr-core" prefix="esrcore"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="/tags/fw" prefix="fw"%>
<%@ taglib uri="/tags/authz" prefix="auth"%>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability'%>
<%@ page import='gov.va.med.esr.common.model.lookup.SSAVerificationStatus'%>

<%-- add a person flag --%>
<c:set var="isAddAPerson" value="false"></c:set>
<c:set var="displayAddAPersonRequiredFieldIndicator" scope="page" value="false"/>
<c:set var="disabledMultipleBirth" scope="page" value="true"/>
<c:set var="disableSelfIdentifiedGenderIdentity" scope="page" value="false"/>



<c:if test="${demographicIdentityTraitsForm.addAPerson == 'true'}">
    <c:set var="isAddAPerson" value="true"></c:set>
    <c:set var="displayAddAPersonRequiredFieldIndicator" value="true"></c:set>
    <c:if test="${demographicIdentityTraitsForm.disabledMultipleBirthIndicator == 'false'}">
    	<c:set var="disabledMultipleBirth" value="false"></c:set>
    </c:if>
</c:if>

    <c:if test="${demographicIdentityTraitsForm.disableSelfIdentifiedGenderIdentity == 'true'}">
        <c:set var="disableSelfIdentifiedGenderIdentity" value="true"></c:set>
    </c:if>

<c:choose>
<c:when test="${displayAddAPersonRequiredFieldIndicator}">
<c:set var="requiredAddAPersonFlag"><%= Boolean.TRUE.toString() %></c:set>
<c:set var="requiredAddAPersonText"><bean-el:message key="label.required"/>,&nbsp;</c:set>
</c:when>
<c:otherwise>
<c:set var="requiredAddAPersonFlag"><%= Boolean.FALSE.toString() %></c:set>
<c:set var="requiredAddAPersonText"></c:set>
</c:otherwise>
</c:choose>

<%-- permission based read only flags --%>
<c:set var="roSSAVerificationStatus" scope="page" value="true" />
<c:set var="roIdentityTraits" scope="page" value="true" />
<c:set var="roVerifiedSSN" scope="page" value="true" />
<c:set var="verifiedStatusCode">
	<%=SSAVerificationStatus.VERIFIED.getName()%>
</c:set>
<c:set var="mmddyyyyText" scope="page">
	<bean-el:message key="label.mmddyyyy" />
</c:set>

<auth:authorize
	ifAnyGranted="<%=Capability.EDIT_SSA_VERIFICATION_STATUS.getName()%>">
	<c:set var="roSSAVerificationStatus" scope="page" value="false" />
</auth:authorize>
<auth:authorize
	ifAnyGranted="<%=Capability.EDIT_IDENTITY_TRAIT_INFO.getName()%>">
	<c:set var="roIdentityTraits" scope="page" value="false" />
</auth:authorize>
<auth:authorize
	ifAnyGranted="<%=Capability.EDIT_VERIFIED_SSN.getName()%>">
	<c:set var="roVerifiedSSN" scope="page" value="false" />
</auth:authorize>
<%-- end of security related changes --%>

<%-- Person Locked Check --%>
<c:set var="appData" value="${AppData}" scope="session" />
<c:set var="personKey" value="SelectedPerson" />
<c:set var="personLocked" value="${appData[personKey].personLocked}" />
<c:if test="${personLocked}">
	<c:set var="roSSAVerificationStatus" scope="page" value="true" />
	<c:set var="roIdentityTraits" scope="page" value="true" />
	<c:set var="roVerifiedSSN" scope="page" value="true" />
</c:if>


<table width="100%" border="0" cellpadding="0" cellspacing="0"
	class="moduleShell">
	<html-el:form action="/demographicIdentityTraits" method="post">
	  <%@ include file="/admin/csrfgentoken.jsp" %>
		<c:set var="viewHistoricalIdentityTraits" scope="page">
			<bean-el:message key="text.viewHistoricalIdentityTraits" />
		</c:set>
		<c:set var="viewSubmittedIdentityTraits" scope="page">
			<bean-el:message key="text.viewSubmittedIdentityTraits" />
		</c:set>
		<tr>
			<td>
			<table width="100%" border="0" cellpadding="0" cellspacing="0"
				class="moduleShellTable">
				<tr>
					<td>
					<table width="100%" border="0" cellpadding="0" cellspacing="0"
						class="moduleShellTableHead">
						<tr>
							<td class="moduleBlueBox"><img alt=""
								src="../images/spacer.gif" width="25" height="17" /></td>
							<td nowrap style="padding-left: 7px"><bean-el:message
								key="label.identityTraits.sectionHeader" /></td>
							<td width="100%"><img alt="" src="../images/spacer.gif"></td>
							<td nowrap class="moduleBlueLink"
								style="padding: 1px 8px 1px 8px"><fw:link
								action="/demographicIdentityTraitsSubmitted?methodName=viewSubmittedData"
								paramId="entityId" paramName="demographicIdentityTraitsForm"
								paramProperty="vpidValue">
								<bean-el:message key="text.viewSubmittedIdentityTraits" />
							</fw:link></td>
							<td><img alt="" src="../images/spacer.gif" width="1" /></td>
							<td nowrap class="moduleBlueLink"
								style="padding: 1px 8px 1px 8px"><fw:link
								action="/demographicIdentityTraitsHistory?methodName=DISPLAY&amp;history=viewHistoricalIdentityTraits"
								paramId="entityId" paramName="demographicIdentityTraitsForm"
								paramProperty="vpidValue">
								<bean-el:message key="text.viewHistoricalIdentityTraits" />
							</fw:link></td>
						</tr>
					</table>
					</td>
				</tr>
				<tr>
					<td>
					<table width="100%" border="0" cellspacing="0" cellpadding="0"
						class="moduleShellTableBody" role="presentation">
						<tr>
							<td width="45%" class="moduleLabel"><fw:label
								forId="txtPrefix" property="prefix">
								<bean-el:message key="label.personal.prefix" />:</fw:label></td>
							<c:set var="sprefixText">
								<bean-el:message key="label.personal.prefix" />
							</c:set>
							<td width="55%" class="moduleValue"><html-el:text
								title="${sprefixText}" styleClass="moduleEdit" styleId="txtPrefix" property="prefix" onblur="toUpperCase(this)"
								size="15" maxlength="10" readonly="${roIdentityTraits}" /></td>
						</tr>
						<tr>
							<td class="moduleLabel"><fw:label property="firstName" forId="txtFirstName">
								<bean-el:message key="label.personal.firstName" />:</fw:label></td>
							<c:set var="firstNameText">
								<bean-el:message key="label.personal.firstName" />
							</c:set>
							<td class="moduleValue"><html-el:text
								title="${firstNameText}" styleClass="moduleEdit"
								property="firstName" styleId="txtFirstName" size="30" maxlength="25" onblur="toUpperCase(this)"
								readonly="${roIdentityTraits}" /></td>
						</tr>
						<tr>
							<td class="moduleLabel"><fw:label property="middleName" forId="txtMiddleName">
								<bean-el:message key="label.personal.middleName" />:</fw:label></td>
							<c:set var="middleNameText">
								<bean-el:message key="label.personal.middleName" />
							</c:set>
							<td class="moduleValue"><html-el:text
								title="${middleNameText}" styleClass="moduleEdit"
								property="middleName" styleId="txtMiddleName" size="30" maxlength="25" onblur="toUpperCase(this)"
								readonly="${roIdentityTraits}" /></td>
						</tr>
						<tr>
							<td class="moduleLabel"><fw:label required="${requiredAddAPersonFlag}" property="lastName" forId="txtLastName">
								<bean-el:message key="label.personal.lastName" />:</fw:label></td>
							<c:set var="lastNameText">
								<bean-el:message key="label.personal.lastName" />
							</c:set>
							<td class="moduleValue"><html-el:text
								title="${requiredAddAPersonText}${lastNameText}" styleClass="moduleEdit"
								property="lastName" styleId="txtLastName" size="40" maxlength="35" onblur="toUpperCase(this)"
								readonly="${roIdentityTraits}" /></td>
						</tr>
						<tr>
							<td class="moduleLabel"><fw:label property="suffix" forId="txtSuffix">
								<bean-el:message key="label.personal.suffix" />:</fw:label></td>
							<c:set var="suffixText">
								<bean-el:message key="label.personal.suffix" />
							</c:set>
							<td class="moduleValue"><html-el:text title="${suffixText}"
								styleClass="moduleEdit" styleId="txtSuffix" property="suffix" size="15" onblur="toUpperCase(this)"
								maxlength="10" readonly="${roIdentityTraits}" /></td>
						</tr>

						<tr>
							<td class="moduleLabel"><fw:label required="${requiredAddAPersonFlag}" property="ssn" forId="txtSsn">
								<bean-el:message key="label.identityTraits.ssn" />:</fw:label></td>
							<c:set var="ssnText">
								<bean-el:message key="label.identityTraits.ssn" />
							</c:set>
							<c:choose>
								<c:when
									test="${demographicIdentityTraitsForm.ssaVerificationStatus == verifiedStatusCode}">
									<td class="moduleValue"><html-el:text title="${requiredAddAPersonText}${ssnText}"
										styleClass="moduleEdit" property="ssn" styleId="txtSsn" size="20"
										maxlength="11" readonly="${roVerifiedSSN}"
										onkeypress="return validateSSN(event)" onkeyup="formatSSN()"
										onblur="formatSSN()" /></td>
								</c:when>
								<c:otherwise>
									<td class="moduleValue"><html-el:text title="${requiredAddAPersonText}${ssnText}"
										styleClass="moduleEdit" property="ssn" styleId="txtSsn" size="20"
										maxlength="11" readonly="${roIdentityTraits}"
										onkeypress="return validateSSN(event)" onkeyup="formatSSN()"
										onblur="formatSSN()" /></td>
								</c:otherwise>
							</c:choose>
						</tr>

						<c:if test="${roSSAVerificationStatus == true}">
							<html-el:hidden name="demographicIdentityTraitsForm"
								property="ssaVerificationStatus"></html-el:hidden>
						</c:if>

						<tr>
							<td class="moduleLabel"><fw:label
								property="ssaVerificationStatus" forId="txtSsaVerificationStatus">
								<bean-el:message
									key="label.identityTraits.ssaVerificationStatus" />:</fw:label></td>
							<c:set var="ssaVerificationStatusText">
								<bean-el:message
									key="label.identityTraits.ssaVerificationStatus" />
							</c:set>
							<td class="moduleValue"><html-el:select
								title="${ssaVerificationStatusText}" styleClass="moduleEdit"
								property="ssaVerificationStatus" styleId="txtSsaVerificationStatus"
								disabled="${roSSAVerificationStatus}">
								<html-el:option value="">
									<bean-el:message key="label.select" />
								</html-el:option>
								<esrcore:options
									collection="gov.va.med.esr.common.model.lookup.SSAVerificationStatus"
									property="code" labelProperty="description" />
							</html-el:select></td>
						</tr>
						<tr>
							<td class="moduleLabel"><fw:label
								property="ssaVerificationDate" forId="txtSsaVerificationDate">
								<bean-el:message key="label.identityTraits.ssaVerificationDate" />:</fw:label></td>
							<td
								title="<bean-el:message key="label.identityTraits.ssaVerificationDate"/>"
								class="moduleValue"><esrcore:displayValue
								name="demographicIdentityTraitsForm"
								property="ssaVerificationDate" /> <html-el:hidden
								styleId="txtSsaVerificationDate"
								name="demographicIdentityTraitsForm"
								property="ssaVerificationDate"></html-el:hidden></td>
						</tr>
						<tr>
							<td class="moduleLabel"><fw:label property="ssaMessage" forId="txtSsaMessage">
								<bean-el:message key="label.identityTraits.ssaMessage" />:</fw:label></td>
							<td
								title="<bean-el:message key="label.identityTraits.ssaMessage"/>"
								class="moduleValue"><esrcore:displayValue
								name="demographicIdentityTraitsForm" property="ssaMessage" /> <html-el:hidden
								styleId="txtSsaMessage"
								name="demographicIdentityTraitsForm" property="ssaMessage"></html-el:hidden>
							</td>
						</tr>

						<c:if test="${roIdentityTraits == true}">
							<html-el:hidden name="demographicIdentityTraitsForm"
								property="pseudoSsnReason"></html-el:hidden>
							<html-el:hidden name="demographicIdentityTraitsForm"
								property="ssnSourceOfChange"></html-el:hidden>
						</c:if>

						<tr>
							<td class="moduleLabel"><fw:label
								property="ssnSourceOfChange" forId="txtSsnSourceOfChange">
								<bean-el:message key="label.identityTraits.ssnSourceOfChange" />:</fw:label></td>
							<td class="moduleValue"><c:set var="ssnSourceOfChangeText">
								<bean-el:message key="label.identityTraits.ssnSourceOfChange" />
							</c:set> <html-el:select title="${ssnSourceOfChangeText}"
								styleClass="moduleEdit" styleId="txtSsnSourceOfChange" property="ssnSourceOfChange"
								disabled="${roIdentityTraits}">
								<html-el:option value="">
									<bean-el:message key="label.select" />
								</html-el:option>
								<esrcore:options
									collection="gov.va.med.esr.common.model.lookup.SSNChangeSource"
									property="code" labelProperty="description" />
							</html-el:select></td>
						</tr>

						<tr>
							<td class="moduleLabel"><fw:label property="pseudoSsnReason" forId="txtPseudoSsnReason">
								<bean-el:message key="label.identityTraits.pseudoSsnReason" />:</fw:label></td>
							<td class="moduleValue"><c:set var="pseudoSsnReasonText">
								<bean-el:message key="label.identityTraits.pseudoSsnReason" />
							</c:set> <html-el:select title="${pseudoSsnReasonText}"
								styleClass="moduleEdit" styleId="txtPseudoSsnReason" property="pseudoSsnReason"
								disabled="${roIdentityTraits}">
								<html-el:option value="">
									<bean-el:message key="label.select" />
								</html-el:option>
								<esrcore:options
									collection="gov.va.med.esr.common.model.lookup.PseudoSSNReason"
									property="code" labelProperty="description" />
							</html-el:select></td>
						</tr>
						<tr>
							<c:choose>
								<c:when test="${requiredAddAPersonFlag}">
									<td class="moduleLabel"><bean-el:message key="label.required.prefix" />&nbsp;
										<bean-el:message key="label.personal.birthSex" />:</td>
									<td class="moduleValue"><c:set var="genderMaleText">
										<bean-el:message key="label.personal.birthSex" />&nbsp;(<bean-el:message
										key="label.male" />)</c:set> <c:set var="genderFemaleText">
										<bean-el:message key="label.personal.birthSex" />&nbsp;(<bean-el:message
										key="label.female" />)</c:set> 
										<html-el:radio title="${requiredAddAPersonText}${genderMaleText}" styleId="txtGenderM" property="gender" value="M" disabled="${roIdentityTraits}" />
										<fw:label forId="txtGenderM" property="gender"><bean-el:message key="label.male" /></fw:label> 
										<html-el:radio title="${genderFemaleText}" property="gender" styleId="txtGenderF" value="F" disabled="${roIdentityTraits}" />
										<fw:label forId="txtGenderF" property="gender"><bean-el:message key="label.female" /></fw:label> 
										<html-el:radio property="gender" value="A" styleId="txtGenderA" style="display:none" /><fw:label forId="txtGenderA" property="gender"><span style="display:none">All</span></fw:label>
										<html-el:radio property="gender" value="N" styleId="txtGenderN" style="display:none" /><fw:label forId="txtGenderN" property="gender"><span style="display:none">N</span></fw:label> 
										<html-el:radio property="gender" value="O" styleId="txtGenderO" style="display:none" /><fw:label forId="txtGenderO" property="gender"><span style="display:none">O</span></fw:label> 
										<html-el:radio property="gender" value="U" styleId="txtGenderU" style="display:none" /><fw:label forId="txtGenderU" property="gender"><span style="display:none">U</span></fw:label>
										<html-el:radio property="gender" value="UN" styleId="txtGenderUN" style="display:none" /><fw:label forId="txtGenderUN" property="gender"><span style="display:none">UN</span></fw:label>
									</td>
								</c:when>
								<c:otherwise>
									<td class="moduleLabel"><bean-el:message key="label.personal.birthSex" />:</td>
									<td class="moduleValue"><c:set var="genderMaleText">
										<bean-el:message key="label.personal.birthSex" />&nbsp;(<bean-el:message
										key="label.male" />)</c:set> <c:set var="genderFemaleText">
										<bean-el:message key="label.personal.birthSex" />&nbsp;(<bean-el:message
										key="label.female" />)</c:set> 
										<html-el:radio title="${requiredAddAPersonText}${genderMaleText}" styleId="txtGenderM" property="gender" value="M" disabled="${roIdentityTraits}" />
										<fw:label forId="txtGenderM" property="gender"><bean-el:message key="label.male" /></fw:label> 
										<html-el:radio title="${genderFemaleText}" property="gender" styleId="txtGenderF" value="F" disabled="${roIdentityTraits}" />
										<fw:label forId="txtGenderF" property="gender"><bean-el:message key="label.female" /></fw:label> 
										<html-el:radio property="gender" value="A" styleId="txtGenderA" style="display:none" /><fw:label forId="txtGenderA" property="gender"><span style="display:none">All</span></fw:label>
										<html-el:radio property="gender" value="N" styleId="txtGenderN" style="display:none" /><fw:label forId="txtGenderN" property="gender"><span style="display:none">N</span></fw:label> 
										<html-el:radio property="gender" value="O" styleId="txtGenderO" style="display:none" /><fw:label forId="txtGenderO" property="gender"><span style="display:none">O</span></fw:label> 
										<html-el:radio property="gender" value="U" styleId="txtGenderU" style="display:none" /><fw:label forId="txtGenderU" property="gender"><span style="display:none">U</span></fw:label>
										<html-el:radio property="gender" value="UN" styleId="txtGenderUN" style="display:none" /><fw:label forId="txtGenderUN" property="gender"><span style="display:none">UN</span></fw:label>
									</td>
								</c:otherwise>
							</c:choose>
						</tr>
                        <tr>
                            <td class="moduleLabel"><bean-el:message key="label.personal.selfIdentifiedGenderIdentity" />:</td>
                            <td class="moduleValue">
                                <c:set var="selfIdentifiedGenderIdentity">
                                    <bean-el:message key="label.personal.selfIdentifiedGenderIdentity" />
                                 </c:set> 
                                 <c:choose>
                                    <c:when test="${disableSelfIdentifiedGenderIdentity}">
                                         <html-el:select title="Self-Identified Gender Identity" styleClass="moduleEdit" styleId="txtSelfIdentifiedGenderIdentity" property="selfIdentifiedGenderIdentity" >
                                            <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>                                
                                         </html-el:select>
                                    </c:when>
                                    <c:otherwise>
                                        <html-el:hidden styleId="txtSelfIdentifiedGenderIdentity" property="selfIdentifiedGenderIdentity"/>
                                    </c:otherwise>
                                 </c:choose>
                             </td>
                        </tr>
						<tr>
							<td class="moduleLabel"><fw:label required="${requiredAddAPersonFlag}" property="dateOfBirth" forId="txtDateOfBirth">
								<bean-el:message key="label.personal.dateOfBirth" />:</fw:label></td>
							<c:set var="dateOfBirthText">
								<bean-el:message key="label.personal.dateOfBirth" />&nbsp;<c:out
									value="${mmddyyyyText}" />
							</c:set>
							<td class="moduleValue"><html-el:text
								title="${requiredAddAPersonText}${dateOfBirthText}" styleClass="moduleEdit"
								property="dateOfBirth" styleId="txtDateOfBirth" size="20" maxlength="10"
								readonly="${roIdentityTraits}" />&nbsp;<bean-el:message
								key="label.mmddyyyy" /></td>
						</tr>

						<!-- add a person -->

						<tr>
							<td class="moduleLabel"><fw:label required="${requiredAddAPersonFlag}"
								property="birthCity" forId="idCity">
								<bean-el:message key="label.identityTraits.placeOfBirthCity" />:</fw:label></td>
							<td id="cityEdit" class="moduleValue"><c:set var="cityText">
							<bean-el:message key="label.required"/>, <bean-el:message key="label.identityTraits.placeOfBirthCity" />
							</c:set> <html-el:text onblur="toUpperCase(this)" title="${cityText}"
								property="birthCity" styleId="idCity" styleClass="moduleEdit"
								size="40" maxlength="15" readonly="${not isAddAPerson}" /></td>
						</tr>
						
						

						<tr>
					      <td class="moduleLabel"><fw:label required="${requiredAddAPersonFlag}" 
					    	property="birthState" forId="stateSelection"><bean-el:message 
					    	key="label.identityTraits.placeOfBirthState" />:</fw:label>
					      </td>
					      <td class="moduleValue">
					        <c:set var="placeOfBirthStateText"><bean-el:message key="label.required"/><bean-el:message key="label.identityTraits.placeOfBirthState"/></c:set>
					        <html-el:select title="${requiredText}${stateText}" styleId="stateSelection" onchange="updateStateFields()" styleClass="moduleEdit" 
					       		property="birthState" tabindex="21" disabled= "${not isAddAPerson}">
					            <html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
					         <esrcore:options collection="gov.va.med.esr.common.model.lookup.State" property="code" labelProperty="description"/>
					        </html-el:select>
					      </td>
					  </tr>
					  

						<tr>
							<td class="moduleLabel"><bean-el:message key="label.identityTraits.multipleBirth" />:</td>
							<td class="moduleValue"><c:forEach var="item"
								items="${yesNoList}">
								<c:set var="multipleBirthText">
									<bean-el:message key="label.identityTraits.multipleBirth" />&nbsp;(<bean-el:message
										key="${item.label}" />)</c:set>
								<html-el:radio title="${multipleBirthText}"
									styleId="idMultipleBirth_${item.value}"
									name="demographicIdentityTraitsForm" property="multipleBirth"
									value="${item.value}" disabled="${disabledMultipleBirth}" />
								<fw:label property="multipleBirth" forId="idMultipleBirth_${item.value}"><bean-el:message key="${item.label}" /></fw:label>
							</c:forEach></td>
						</tr>
						<tr>
							<td class="moduleLabel"><fw:label
								property="mothersMaidenName" forId="txtMothersMaidenName">
								<bean-el:message key="label.identityTraits.mothersMaidenName" />:</fw:label></td>
							<td id="mothersMaidenNameEdit" class="moduleValue"><c:set
								var="mothersMaidenNameText">
								<bean-el:message key="label.identityTraits.mothersMaidenName" />
							</c:set> <html-el:text title="${mothersMaidenNameText}"
								styleClass="moduleEdit" styleId="txtMothersMaidenName" property="mothersMaidenName" size="40" onblur="toUpperCase(this)"
								maxlength="40" readonly="${not isAddAPerson}" /></td>
						</tr>
						
					 <tr>
                		<td class="moduleLabel"><fw:label property="race" forId="txtRace">
                			<bean-el:message key="label.identityTraits.race" />:</fw:label></td>
                		<td class="moduleValue">
                			<c:set var="raceText"><bean-el:message key="label.identityTraits.race"/></c:set>
                			<html-el:select title="${raceText}" styleClass="moduleEdit" styleId="txtRace" property="raceSelections" multiple="true" size="8" disabled="${not isAddAPerson}" >
                  			<html-el:option value=""><bean-el:message key="label.select" /></html-el:option>
                  			<esrcore:options collection="gov.va.med.esr.common.model.lookup.RaceType" property="code" labelProperty="name"/>
                			</html-el:select>
                		</td>
              		</tr>		
					<c:choose>
							<c:when test="${isAddAPerson}">	
              		<tr>
							<td class="moduleLabel"><fw:label property="ethnicity" forId="txtEthnicity">
								<bean-el:message key="label.identityTraits.ethnicity" />:</fw:label></td>
							<td class="moduleValue"><c:set var="ethnicityText">
								<bean-el:message key="label.identityTraits.ethnicity" />
							</c:set> <html-el:select title="${ethnicityText}" styleClass="moduleEdit"
								property="ethnicity" styleId="txtEthnicity">
								<html-el:option value="">
									<bean-el:message key="label.select" />
								</html-el:option>
								<esrcore:options
									collection="gov.va.med.esr.common.model.lookup.EthnicityType"
									property="code" labelProperty="name" />
							</html-el:select></td>
						</tr>		
              		</c:when>
              		<c:otherwise>
							<tr>
							<td class="moduleLabel"><fw:label property="ethnicity" forId="txtEthnicity" >
								<bean-el:message key="label.identityTraits.ethnicity" />:</fw:label></td>
							<td
								title="<bean-el:message key="label.identityTraits.ethnicity"/>"
								class="moduleValue">
								<esrcore:displayValue name="demographicIdentityTraitsForm" property="ethnicity" /> 
								<html-el:hidden	name="demographicIdentityTraitsForm" styleId="txtEthnicity" property="ethnicity"></html-el:hidden>
							</td>
						</tr>
						</c:otherwise>
					</c:choose>
						<tr>
							<td colspan=2 height="50">
							<table width="100%" border="0" cellpadding="0" cellspacing="0" role="presentation">
								<tr>
									<c:choose>
										<c:when
											test="${roSSAVerificationStatus && roIdentityTraits && roVerifiedSSN}">
											<td width="50%"><img alt="" src="../images/spacer.gif" /></td>
											<td><img alt="" src="../images/buttonEndLeft.gif" /></td>
											<td><html-el:submit property="methodName"
												style="width:50; vertical-align: top;"
												styleClass="buttonText">
												<bean-el:message key="button.cancel" />
											</html-el:submit></td>
											<td><img alt="" src="../images/buttonEndRight.gif" /></td>
											<td width="50%"><img alt="" src="../images/spacer.gif" /></td>
										</c:when>
										<c:otherwise>
											<td width="45%"><img alt="" src="../images/spacer.gif" /></td>
											<td><img alt="" src="../images/buttonEndLeft.gif" /></td>
											<td>
											<html-el:submit property="methodName" 
												style="width:50; vertical-align: top;"
												styleClass="buttonText">
												<bean-el:message key="button.update" />
											</html-el:submit></td>
											<td><img alt="" src="../images/buttonEndRight.gif" /></td>
											<td width="1%"><img alt="" src="../images/spacer.gif" /></td>
											<td><img alt="" src="../images/buttonEndLeft.gif" /></td>
											<td><html-el:submit property="methodName"
												style="width:50; vertical-align: top;"
												styleClass="buttonText">
												<bean-el:message key="button.cancel" />
											</html-el:submit></td>
											<td><img alt="" src="../images/buttonEndRight.gif" /></td>
											<td width="45%"><img alt="" src="../images/spacer.gif" /></td>
										</c:otherwise>
									</c:choose>
								</tr>
							</table>
							</td>
						</tr>
					</table>
					</td>
				</tr>
			</table>
			</td>
		</tr>
		<c:if test="${demographicIdentityTraitsForm.disabledMultipleBirthIndicator == 'true'}">
		<html-el:hidden name="demographicIdentityTraitsForm" property="multipleBirth"/>
		</c:if>
		<html-el:hidden name="demographicIdentityTraitsForm" property="addAPerson"/>
		<html-el:hidden name="demographicIdentityTraitsForm" property="disabledMultipleBirthIndicator"/>
	</html-el:form>
</table>
