<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<%-- Set the default permissions so the user has all permissions --%>
<c:set var="tabPreviouslyMailed" value="true"/>
<c:set var="tabAvailableForMailing" value="true"/>
<c:set var="tabVhicCardStatus" value="true"/>
<c:set var="tabIRSSubmission" value="true"/>
<c:set var="tabVcDetermination" value="false"/>

<%-- 10386 added tab for handbook status --%>
<c:set var="tabHandbookStatus" value="false"/>
<auth:authorize ifAnyGranted="<%=Capability.VIEW_HANDBOOK_STATUS.getName()%>">
  <c:set var="tabHandbookStatus" value="true"/>
</auth:authorize>

<c:set var="tabDeliveryPreferences" value="false"/>
<auth:authorize ifAnyGranted="<%=Capability.VIEW_HANDBOOK_STATUS.getName()%>">
  <c:set var="tabDeliveryPreferences" value="true"/>
</auth:authorize>

<c:set var="tabIRSSubmission" value="false"/>
<auth:authorize ifAnyGranted="<%=Capability.VIEW_ACA_COMMUNICATIONS.getName()%>">
  <c:set var="tabIRSSubmission" value="true"/>
</auth:authorize>
<auth:authorize ifAnyGranted="<%=Capability.MANAGE_ACA_COMMUNICATIONS.getName()%>">
  <c:set var="tabIRSSubmission" value="true"/>
</auth:authorize>


<%-- Set the default background color and border styles for the tabs --%>
<c:set var="previouslyMailedStyle">background-color: #9FACCA;</c:set>
<c:set var="availableForMailingStyle">background-color: #9FACCA;</c:set>
<c:set var="handbookStatusStyle">background-color: #9FACCA;</c:set>
<c:set var="deliveryPreferencesStyle">background-color: #9FACCA;</c:set>
<c:set var="vhicCardStatusStyle">background-color: #9FACCA;</c:set>
<c:set var="irsSubmissionStyle">background-color: #9FACCA;</c:set>
<c:set var="vcDeterminationStyle">background-color: #9FACCA;</c:set>

<c:set var="previouslyMailedBottomBorderStyle">border-bottom: 1px solid #000000;</c:set>
<c:set var="availableForMailingBottomBorderStyle">border-bottom: 1px solid #000000;</c:set>
<c:set var="handbookStatusBottomBorderStyle">border-bottom: 1px solid #000000;</c:set>
<c:set var="deliveryPreferencesBottomBorderStyle">border-bottom: 1px solid #000000;</c:set>
<c:set var="vhicCardStatusBottomBorderStyle">border-bottom: 1px solid #000000;</c:set>
<c:set var="irsSubmissionBottomBorderStyle">border-bottom: 1px solid #000000;</c:set>
<c:set var="vcDeterminationBottomBorderStyle">border-bottom: 1px solid #000000;</c:set>
<c:set var="leftBorderStyle">border-left: 1px solid #000000;</c:set>

<%-- Set the default "title" Text --%>
<c:set var="previouslyMailedText"><bean-el:message key="title.commsLog"/>&nbsp;<bean-el:message key="label.subtab"/></c:set>
<c:set var="availableForMailingText"><bean-el:message key="title.availForMailing"/>&nbsp;<bean-el:message key="label.subtab"/></c:set>
<c:set var="handbookStatusText"><bean-el:message key="title.handbookStatus"/>&nbsp;<bean-el:message key="label.subtab"/></c:set>
<c:set var="deliveryPreferencesText"><bean-el:message key="title.deliveryPreferences"/>&nbsp;<bean-el:message key="label.subtab"/></c:set>
<c:set var="vhicCardStatusText"><bean-el:message key="title.vhicCardStatus"/>&nbsp;<bean-el:message key="label.subtab"/></c:set>
<c:set var="irsSubmissionText"><bean-el:message key="title.irsSubmission"/>&nbsp;<bean-el:message key="label.subtab"/></c:set>
<c:set var="vcDeterminationText"><bean-el:message key="title.displayVCDetermination"/>&nbsp;<bean-el:message key="label.subtab"/></c:set>
<c:set var="selectedSubTabText"><bean-el:message key="label.selectedSubTab"/>,&nbsp;</c:set>

<%-- Adjust the title text and the background color based on the selected tab --%>
<c:if test="${subTabName == 'previouslyMailed'}">
  <c:set var="previouslyMailedText" value="${selectedSubTabText}${previouslyMailedText}"/>
  <c:set var="previouslyMailedStyle">background-color: #EDF2FB;</c:set>
  <c:set var="previouslyMailedBottomBorderStyle"></c:set>
</c:if>

<c:if test="${subTabName == 'availableForMailing'}">
  <c:set var="availableForMailingText" value="${selectedSubTabText}${availableForMailingText}"/>
  <c:set var="availableForMailingStyle">background-color: #EDF2FB;</c:set>
  <c:set var="availableForMailingBottomBorderStyle"></c:set>
</c:if>

<c:if test="${subTabName == 'handbookStatus'}">
  <c:set var="handbookStatusText" value="${selectedSubTabText}${handbookStatusText}"/>
  <c:set var="handbookStatusStyle">background-color: #EDF2FB;</c:set>
  <c:set var="handbookStatusBottomBorderStyle"></c:set>
</c:if>

<c:if test="${subTabName == 'deliveryPreferences'}">
  <c:set var="deliveryPreferencesText" value="${selectedSubTabText}${deliveryPreferencesText}"/>
  <c:set var="deliveryPreferencesStyle">background-color: #EDF2FB;</c:set>
  <c:set var="deliveryPreferencesBottomBorderStyle"></c:set>
</c:if>

<c:if test="${subTabName == 'vhicCardStatus'}">
  <c:set var="vhicCardStatusText" value="${selectedSubTabText}${vhicCardStatusText}"/>
  <c:set var="vhicCardStatusStyle">background-color: #EDF2FB;</c:set>
  <c:set var="vhicCardStatusBottomBorderStyle"></c:set>
</c:if>

<c:if test="${subTabName == 'irsSubmission' || subTabName=='irsCorrection'}">
  <c:set var="irsSubmissionText" value="${selectedSubTabText}${irsSubmissionText}"/>
  <c:set var="irsSubmissionStyle">background-color: #EDF2FB;</c:set>
  <c:set var="irsSubmissionBottomBorderStyle"></c:set>
</c:if>

<c:if test="${subTabName == 'vcDetermination'}">
  <c:set var="vcDeterminationText" value="${selectedSubTabText}${vcDeterminationText}"/>
  <c:set var="vcDeterminationStyle">background-color: #EDF2FB;</c:set>
  <c:set var="vcDeterminationBottomBorderStyle"></c:set>
</c:if>

<table width="100%" border="0" cellpadding="0" cellspacing="0">
  <tr class="moduleShellTable" style="background-color: #EDF2FB;" height="30px">

    <c:if test="${tabPreviouslyMailed == true}">
    <td align="center" style="<c:out value="${previouslyMailedStyle}"/> padding: 1 10 1 10; <c:out value="${leftBorderStyle}"/> border-right: 1px solid #000000; border-top: 1px solid #000000; <c:out value="${previouslyMailedBottomBorderStyle}"/>" nowrap><html-el:link  styleClass="tabLink" title="${previouslyMailedText}" action="commslog.do?methodName=Previously Mailed"><bean-el:message key="title.commsLog"/></html-el:link></td>
    <c:set var="leftBorderStyle"></c:set>
    </c:if>

    <c:if test="${tabAvailableForMailing == true}">
    <td align="center" style="<c:out value="${availableForMailingStyle}"/> padding: 1 10 1 10; <c:out value="${leftBorderStyle}"/> border-right: 1px solid #000000; border-top: 1px solid #000000; <c:out value="${availableForMailingBottomBorderStyle}"/>" nowrap><html-el:link  styleClass="tabLink" title="${availableForMailingText}" action="commslog.do?methodName=Available for Mailing"><bean-el:message key="title.availForMailing"/></html-el:link></td>
    <c:set var="leftBorderStyle"></c:set>
    </c:if>

    <c:if test="${tabHandbookStatus == true}">
    <td align="center" style="<c:out value="${handbookStatusStyle}"/> padding: 1 10 1 10; <c:out value="${leftBorderStyle}"/> border-right: 1px solid #000000; border-top: 1px solid #000000; <c:out value="${handbookStatusBottomBorderStyle}"/>" nowrap><html-el:link styleClass="tabLink" title="${handbookStatusText}" action="commslog.do?methodName=Handbook Status"><bean-el:message key="title.handbookStatus"/></html-el:link></td>
    <c:set var="leftBorderStyle"></c:set>
    </c:if>

    <c:if test="${tabDeliveryPreferences == true}">
    <td align="center" style="<c:out value="${deliveryPreferencesStyle}"/> padding: 1 10 1 10; <c:out value="${leftBorderStyle}"/> border-right: 1px solid #000000; border-top: 1px solid #000000; <c:out value="${deliveryPreferencesBorderStyle}"/>" nowrap><html-el:link styleClass="tabLink" title="${deliveryPreferencesText}" action="deliveryPreferences.do?methodName=Delivery Preferences"><bean-el:message key="title.deliveryPreferences"/></html-el:link></td>
    <c:set var="leftBorderStyle"></c:set>
    </c:if>

   <c:if test="${tabVhicCardStatus == true}">
    <td align="center" style="<c:out value="${vhicCardStatusStyle}"/> padding: 1 10 1 10; <c:out value="${leftBorderStyle}"/> border-right: 1px solid #000000; border-top: 1px solid #000000; <c:out value="${vhicCardStatusBorderStyle}"/>" nowrap><html-el:link styleClass="tabLink" title="${vhicCardStatusText}" action="commslog.do?methodName=VHIC Status"><bean-el:message key="title.vhicCardStatus"/></html-el:link></td>
    <c:set var="leftBorderStyle"></c:set>
    </c:if>

    <c:if test="${tabIRSSubmission == true}">
    <td align="center" style="<c:out value="${irsSubmissionStyle}"/> padding: 1 10 1 10; <c:out value="${leftBorderStyle}"/> border-right: 1px solid #000000; border-top: 1px solid #000000; <c:out value="${irsSubmissionBorderStyle}"/>" nowrap><html-el:link styleClass="tabLink" title="${irsSubmissionText}" action="commslog.do?methodName=ACA Reporting"><bean-el:message key="title.irsSubmission"/></html-el:link></td>
    <c:set var="leftBorderStyle"></c:set>
    </c:if>

    <c:if test="${tabVcDetermination == true}">
    <td align="center" style="<c:out value="${vcDeterminationStyle}"/> padding: 1 10 1 10; <c:out value="${leftBorderStyle}"/> border-right: 1px solid #000000; border-top: 1px solid #000000; <c:out value="${vcDeterminationBottomBorderStyle}"/>" nowrap><html-el:link styleClass="tabLink" title="${vcDeterminationText}" action="commslog.do?methodName=VC Determination"><bean-el:message key="title.displayVCDetermination"/></html-el:link></td>
    <c:set var="leftBorderStyle"></c:set>
    </c:if>

    <td width="100%" style="border-bottom: 1px solid #000000;"><img alt=""  src="../images/spacer.gif" height="1" width="100%"/></td>
  </tr>
</table>
