<script language="JavaScript" src="../scripts/ESR-Script.js"></script>
<%@ taglib uri="/tags/fw" prefix="fw" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="/tags/struts-html" prefix="html" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/authz" prefix="auth" %>
<%@ page import='gov.va.med.esr.common.model.lookup.Capability' %>

<c:set var="assignedText" scope="page"><bean-el:message key="label.assigned"/></c:set>
<c:set var="expandableSectionCollapsed" scope="page"><bean-el:message key="label.expandableSectionCollapsed"/></c:set>

<script language="javascript">
function deleteSetError()
{
  var errorMessage = "This set is assigned to a User/Role and can not be deleted.";
  alert(errorMessage);
  return false;
}

function deleteSetConfirm()
{
  var confirmMessage = "Do you really want to delete this Capability Set?";
  return confirm(confirmMessage);
}

function confirmSetUpdate()
{
  var message = "This Capability Set is assigned to a User/Role. Do you still want to edit?";
  return confirm(message);
}
function expandAllSets()
{
  expandCollapseLists("setList", "setListImage", "setListHiddenId", null);
  document.getElementById("collapseAllLink").style.display="block";
  document.getElementById("expandAllLink").style.display="none";
  return false;
}

function collapseAllSets()
{
  expandCollapseLists("setList", "setListImage", "setListHiddenId", null);
  document.getElementById("collapseAllLink").style.display="none";
  document.getElementById("expandAllLink").style.display="block";
  return false;
}

</script>

<table width="100%" border="1" cellpadding="0" cellspacing="0" class="moduleShell">
  <html:form action="/editCapabilitySet" method="post">
  <%@ include file="/admin/csrfgentoken.jsp" %>
  <%-- Permissions --%>
  <c:set var="addCode"><%=Capability.ADD_CAPABILITY_SETS.getName()%></c:set>
  <c:set var="editCode"><%=Capability.EDIT_CAPABILITY_SETS.getName()%></c:set>
  <c:set var="deleteCode"><%=Capability.DELETE_CAPABILITY_SETS.getName()%></c:set>
  <c:set var="addPermission" value="false"/>
  <c:set var="editPermission" value="false"/>
  <c:set var="deletePermission" value="false"/>
  <auth:authorize ifAnyGranted="${addCode},${editCode}">
    <c:set var="addPermission" value="true"/>
  </auth:authorize>
  <auth:authorize ifAnyGranted="${editCode}">
    <c:set var="editPermission" value="true"/>
  </auth:authorize>
  <auth:authorize ifAnyGranted="${deleteCode}">
    <c:set var="deletePermission" value="true"/>
  </auth:authorize>

  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable">
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
              <tr>
                <td class="moduleBlueBox"><img alt=""  src="../images/spacer.gif" width="28" height="23"/></td>
                <td nowrap class="moduleHeadline"><bean-el:message key="label.capabilitySets"/></td>
                <td width="90%"><img alt=""  src="../images/spacer.gif"/></td>
                <c:if test="${addPermission}">
                <td><img alt=""  src="../images/buttonEndLeft.gif"/></td>
                <td><html-el:submit property="methodName" style="width:120; vertical-align: top;" styleClass="buttonText"><bean-el:message key="button.addCapabilitySet"/></html-el:submit></td>
                <td><img alt=""  src="../images/buttonEndRight.gif"/></td>
                <td width="1%"><img alt=""  src="../images/spacer.gif"/></td>
                </c:if>
                <td nowrap class="moduleBlueLink" style="padding: 1 8 1 8">
                  <div id="expandAllLink" style="display:block">
                    <fw:link onclick="return(expandAllSets());return false" action="none">EXPAND ALL</fw:link>
                  </div>
                  <div id="collapseAllLink" style="display:none">
                    <fw:link onclick="return(collapseAllSets());return false" action="none">COLLAPSE ALL</fw:link>
                  </div>
                </td>
              </tr>
            </table>
          </td>
        </tr>

<!--CCR13058 - 508- The user is unable to use table commands after the link is expanded on the data table on the Capabilities tab- Adding Sumamry for navigation help
 					Commenting out internal nested tables and adding formatting to <div> tag to maintain the same UI -->
 					
        <tr>
          <td>
            <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
              <tr>
                <td style="padding:10 10 10 10">
                  <table summary="Table for Capability Sets
                    Use Enter or Space Bar, to expand a link. Continue using table commands to read the next row within expanded link. Within the expanded link, use the up and down arrow keys to read line by line.
					To return to the expanded link, use the up arrow keys and collapse the link by using Enter or Space Bar. To return to the first level/main expandable link use table commands and then collapse it.
                    Continue using normal table commands to read the rest of the table."
					width="100%" border="0" cellspacing="0" cellpadding="0">
                    <thead>
                    <tr>
                      <th scope="col" width="38%" class="darkValue" valign="bottom" nowrap style="padding:5 5 5 5"><b><bean-el:message key="label.name"/></b></th>
                      <th scope="col" width="10%" class="darkValue" valign="bottom" nowrap style="padding:5 5 5 5"><b><bean-el:message key="label.activeDate"/></b></th>
                      <th scope="col" width="12%" class="darkValue" valign="bottom" nowrap style="padding:5 5 5 5"><b><bean-el:message key="label.inactivedate"/></b></th>
                      <th scope="col" width="10%" class="darkValue" valign="bottom" nowrap style="text-align:center;padding:5 5 5 5"><b><bean-el:message key="label.assigned"/></b></th>
                      <th scope="col" width="8%" class="darkValue" valign="bottom" nowrap style="padding:5 5 5 5"><b><img role="presentation" alt="edit"  src="../images/spacer.gif" width="1" height="1" /></b></th>
                      <th scope="col" width="10%" class="darkValue" valign="bottom" nowrap style="padding:5 5 5 5"><b><img role="presentation" alt="delete"  src="../images/spacer.gif" width="1" height="1" /></b></th>
                      <th scope="col" width="12%" class="darkValue" valign="bottom" wrap style="padding:5 5 5 5"><b><img role="presentation" alt="history"  src="../images/spacer.gif" width="1" height="1" /></b></th>
                    </tr>
                    </thead>

                    <c:if test="${not empty CapabilitySets}">
                    <tbody>
                    <c:forEach var="capabilitySet" items="${CapabilitySets}" varStatus="status">
                    <c:set var="setid" value="${capabilitySet.entityKey.keyValue}"/>
                    <c:set var="counter" value="${status.count - 1}" />
                    <c:set var="assigned" value="${capabilitySet.assigned}"/>
                    <c:set var="rowColor" value="darkValue" />
                    <tr>
                      <td scope="row" width="38%" nowrap style="text-align: left;padding:5 5 5 5" class="moduleLabel">
                        <fw:link href="." onclick="expandOrCollapse(setList${counter}, setListImage${counter}, setListHiddenId${counter}); return false">
                          <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="setListImage${counter}" src="../images/redArrowRight.gif"/><c:out value="${capabilitySet.name}"/>
                        </fw:link>
                        <input name="setListHiddenId<c:out value="${counter}"/>" id="setListHiddenId<c:out value="${counter}"/>" type="hidden" value="false"/>
                      </td>
                      <td nowrap width="10%" style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
                        <esrcore:displayDate name="capabilitySet" dateProperty="activeDate" displayTime="false" nullText=""/>
                      </td>
                      <td nowrap width="12%" style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
                        <esrcore:displayDate name="capabilitySet" dateProperty="inactiveDate" displayTime="false" nullText=""/>
                      </td>
                          <td nowrap width="10%" style="padding:5 5 5 5;text-align: center">
                        <c:if test="${assigned}"><html-el:img alt="${assignedText}"  src="../images/check_green.gif"/></c:if>
                      </td>
                      <td nowrap width="8%" style="text-align: center;font-size:10pt">
                        <c:if test="${editPermission}">
                        <c:if test="${not assigned}">
                          <fw:link action="editCapabilitySet.do?methodName=EDIT" paramId="capabilitySetId" paramName="setid">
                            <bean-el:message key="button.edit"/>
                          </fw:link>
                        </c:if>
                        <c:if test="${assigned}">
                          <fw:link onclick="return(confirmSetUpdate()); return false" action="editCapabilitySet.do?methodName=EDIT" paramId="capabilitySetId" paramName="setid">
                            <bean-el:message key="button.edit"/>
                          </fw:link>
                        </c:if>
                        </c:if>
                      </td>
                      <td nowrap width="10%" style="text-align: center;font-size:10pt">
                        <c:if test="${deletePermission}">
                        <c:if test="${assigned}">
                          <fw:link onclick="deleteSetError(); return false" action="editCapabilitySet.do?methodName=DELETE" paramId="capabilitySetId" paramName="setid">
                            <bean-el:message key="button.delete"/>
                          </fw:link>
                        </c:if>
                        <c:if test="${not assigned}">
                          <fw:link onclick="return(deleteSetConfirm()); return false" action="editCapabilitySet.do?methodName=DELETE" paramId="capabilitySetId" paramName="setid">
                            <bean-el:message key="button.delete"/>
                          </fw:link>
                        </c:if>
                        </c:if>
                      </td>
                      <td nowrap width="12%" style="text-align: center;font-size:10pt">
                        <fw:link
                          action="/viewCapabilitySetHistory?methodName=DISPLAY&amp;history=viewHistoricalCapabilitySet" paramId="entityId" paramName="capabilitySet" paramProperty="entityKey.keyValue">
                        <bean-el:message key="button.history"/>
                        </fw:link>
                      </td>
                    </tr>

                    <!-- List of Capabilities -->
                    <tr>
                      <td colspan="7">
                        <div id="<c:out value="setList${counter}"/>" class="expandCollapseBody" style= "font-family: Verdana, Arial, Helvetica, sans-serif;
							font-size: 11px;
							font-weight: normal;
							color: #000000;text-align: left;margin:5px 0px 0px 25px;">
                      <!--   <table role="presentation"> -->
                          <c:forEach var="capability" items="${capabilitySet.capabilities}" varStatus="status">
                        <!--  <tr>
                            <td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
                              &nbsp;
                            </td>
                            <td nowrap style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>"> -->
                              <c:out value="${capability.name}"/><br/><br/>
                         <!--    </td>
                            <td width="100%"><img alt=""  src="../images/spacer.gif"/></td>
                          </tr> -->
                          </c:forEach>
                     <!--    </table>	-->
                        </div>
                      </td>
                    </tr>
                    </c:forEach>
                    </tbody>
                    </c:if>
                  </table>
                </td>
              </tr>

              <%-- Deleted Capability Sets --%>
              <c:if test="${not empty DeletedCapabilitySets}">
              <tr>
                <td>
                  <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellLowTableHead" role="presentation">
                    <tr>
                      <td class="moduleBrownBox"><img alt="" src="../images/spacer.gif" width="29" height="1"/></td>
                      <td>&nbsp;</td>
                      <td class="moduleLabel" nowrap>
                        <fw:link href="." onclick="expandOrCollapse(deletedCapabilitySetsBlock, deletedCapabilitySetsImage, deletedCapabilitySetsHiddenId); return false">
                          <html-el:img alt="${expandableSectionCollapsed}" align="center" border="0" styleId="deletedCapabilitySetsImage" src="../images/redArrowRight.gif"/><bean-el:message key="label.deletedCapabilitySets"/>
                        </fw:link>
                        <input name="deletedCapabilitySetsHiddenId" id="deletedCapabilitySetsHiddenId" type="hidden" value="false"/>
                      </td>
                      <td width="100%"><img alt=""  src="../images/spacer.gif"></td>
                    </tr>
                  </table>
                </td>
              </tr>
              </c:if>

              <tr>
                <td style="padding:5 10 10 10">
                  <%-- Deleted roles --%>
                  <c:if test="${not empty DeletedCapabilitySets}">
                  <table summary="Table for Deleted Capability Sets" width="100%" border="0" cellspacing="0" cellpadding="0" id="deletedCapabilitySetsBlock" style="display:none" role="presentation">
                    <tr>
                      <td width="38%"><img role="presentation" alt="name"  src="../images/spacer.gif"/></td>
                      <td width="10%"><img role="presentation" alt="active date"  src="../images/spacer.gif"/></td>
                      <td width="12%"><img role="presentation" alt="inactive date"  src="../images/spacer.gif"/></td>
                      <td width="10%"><img role="presentation" alt="assigned"  src="../images/spacer.gif"/></td>
                      <td width="8%"><img role="presentation" alt="edit"  src="../images/spacer.gif"/></td>
                      <td width="10%"><img role="presentation" alt="delete"  src="../images/spacer.gif"/></td>
                      <td width="12%"><img role="presentation" alt="history"  src="../images/spacer.gif"/></td>
                    </tr>
                    <tbody>
                    <c:forEach var="capabilitySet" items="${DeletedCapabilitySets}" varStatus="status">
                    <c:set var="setid" value="${capabilitySet.entityKey.keyValue}"/>
                    <c:set var="counter" value="${status.count - 1}" />
                    <tr>
                      <td scope="row" nowrap width="38%" style="text-align: left;padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
                        <c:out value="${capabilitySet.name}"/>
                       </td>
                       <td nowrap width="10%" style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
                         <esrcore:displayDate name="capabilitySet" dateProperty="activeDate" displayTime="false" nullText=""/>
                       </td>
                       <td nowrap width="12%" style="padding:5 5 5 5" class="<c:out value="${rowColor}"/>">
                         <esrcore:displayDate name="capabilitySet" dateProperty="inactiveDate" displayTime="false" nullText=""/>
                       </td>
                       <td width="10%"><img alt=""  src="../images/spacer.gif"/></td>
                       <td width="8%"><img alt=""  src="../images/spacer.gif"/></td>
                       <td width="10%"><img alt=""  src="../images/spacer.gif"/></td>
                       <td nowrap width="12%" style="text-align: center;font-size:10pt">
                          <fw:link
                            action="/viewCapabilitySetHistory?methodName=DISPLAY&amp;history=viewHistoricalCapabilitySet"
                            paramId="entityId" paramName="capabilitySet" paramProperty="entityKey.keyValue">
                              <bean-el:message key="button.history"/>
                          </fw:link>
                      </td>
                    </tr>
                    </c:forEach>
                    </tbody>
                  </table>
                  </c:if>
                </td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
  </html:form>
</table>
