<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>

<c:set var="rowColor" value="value" />
<c:set var="batchProcessDetail" value="${job.batchProcessDetail}"/>

<html-el:hidden name="batchProcessDetail" property="jobName"/>
<html-el:hidden name="batchProcessDetail" property="jobGroup"/>

<table summary="Detail for the selected batch process">
	<thead>
	<tr>
		<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.batchProcessManagement.header.id"/></th>
		<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.batchProcessManagement.header.description"/></th>
		<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.batchProcessManagement.header.nextFireTime"/></th>
		<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.batchProcessManagement.header.status"/></th>
	</tr>
	</thead>
	<tbody>
	<tr>				
		<td scope="row" width="20%" align="left" valign="top" class="<c:out value="${rowColor}"/>" nowrap>
			<esrcore:displayValue name="job" property="batchProcessDetail.jobName"/>							
		</td>
		<td width="20%" align="left" valign="top" class="<c:out value="${rowColor}"/>">
			<esrcore:displayValue name="job" property="batchProcessDetail.jobDescription"/>
		</td>
		<td width="20%" align="left" valign="top" class="<c:out value="${rowColor}"/>">
			<esrcore:displayDate name="job" dateProperty="triggerStatus.nextFireTime" displayTime="true"/>
		</td>	
		<td width="20%" align="left" valign="top" class="<c:out value="${rowColor}"/>" nowrap>
			<c:choose>
				<c:when test="${job.active}">
					<esrcore:displayValue name="job" property="triggerStatus.status"/>								
				</c:when>
				<c:otherwise>
					<span style="color:#FF0000">
						<esrcore:displayValue name="job" property="triggerStatus.status"/>
					</span>										
				</c:otherwise>
			</c:choose>
		</td>					
	</tr>
	</tbody>
</table>
