<%@ taglib uri="/tags/struts-bean-el" prefix="bean-el" %>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html-el" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/tags/esr-core" prefix="esrcore" %>
<%@ taglib uri="/tags/fw" prefix="fw" %> 

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShell">
<html-el:form action="/batchProcess" method="post">	
  <%@ include file="/admin/csrfgentoken.jsp" %>
  <tr>
    <td>
      <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTable">
        <tr>
          <td>
            <table width="100%" border="0" cellpadding="0" cellspacing="0" class="moduleShellTableHead">
              <tr>
	            <td class="moduleBlueBox">&nbsp;</td>
                <td class="moduleHeadline" nowrap><bean-el:message key="label.batchProcessActive.mainHeader"/></td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td>
    	    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="moduleShellTableBody">
              <tr>
                <td>&nbsp;</td>
              </tr>
				
			<c:choose>
				<c:when test="${activeJobs == null}">
					  <tr>
						<td class="moduleLabel" style="text-align: left; padding-left: 20"><bean-el:message key="message.batchProcessActive.none"/></td>
					  </tr>
				</c:when>
				<c:otherwise>					
					<tr>
						<td class="moduleLabel" style="text-align: left; padding-left: 20"><bean-el:message key="message.batchProcessActive.instructions"/></td>
					</tr>
	  
					<tr><td>&nbsp;</td></tr>				
				
					<tr>
						<td>
							<table summary="Table for Active Batch Processes">
							<thead>
								<tr>
									<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.batchProcessManagement.header.id"/></th>									
									<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.batchProcessResult.startDate"/></th>
									<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.batchProcessResult.runBy"/></th>
									<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.batchProcessResult.statistics"/></th>				
									<th scope="col" style="text-align:left; padding: 7 0 7 5" class="darkLabel"><bean-el:message key="label.batchProcessManagement.header.actions"/></th>									
								</tr>
							</thead>
							<c:set var="rowColor" value="darkValue"/>
							<tbody>
							<c:forEach var="jobResult" items="${activeJobs}">
								<c:choose>
									<c:when test="${rowColor == 'darkValue'}">
										<c:set var="rowColor" value="value" />
									</c:when>
									<c:otherwise>
										<c:set var="rowColor" value="darkValue" />
									</c:otherwise>
								</c:choose>
				
								 <tr>				
									<td scope="row" width="20%" align="left" valign="top" class="<c:out value="${rowColor}"/>" nowrap>
										<esrcore:displayValue name="jobResult" property="jobName"/>							
									</td>
										<td width="20%" align="left" valign="top" class="<c:out value="${rowColor}"/>" nowrap>
											<esrcore:displayDate name="jobResult" dateProperty="startDate" displayTime="true"/>
										</td>
										<td width="20%" align="left" valign="top" class="<c:out value="${rowColor}"/>" nowrap>
											<esrcore:displayValue name="jobResult" property="context"/>							
										</td>
										<td width="20%" align="left" valign="top" class="<c:out value="${rowColor}"/>">
											<esrcore:displayValue name="jobResult" property="statistics"/>							
										</td>
										<td width="20%" align="left" valign="top" class="<c:out value="${rowColor}"/>" nowrap>
											<fw:link action="batchProcess.do?methodName=Cancel&amp;jobResultId=${jobResult.entityKey.keyValue}">
												<bean-el:message key="link.batchProcessActive.markAsCancelled"/>
											</fw:link> | 
											<fw:link action="batchProcess.do?methodName=Error&amp;jobResultId=${jobResult.entityKey.keyValue}">
												<bean-el:message key="link.batchProcessActive.markAsError"/>
											</fw:link>
										</td>
									</tr>										
								</c:forEach>
								</tbody>
							</table>
						</td>
					</tr>
				</c:otherwise>
			</c:choose>
			
            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
	</html-el:form>
</table>

