/********************************************************************
 * Copyright  2007 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.ui.util;

import gov.va.med.esr.common.ui.form.FinancialDetailsData;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.ObjectVersioningUtil;

/**
 * Verifies integrity of object evolution for serialized instances in UI.
 * 
 * <p>For more details, see the javadoc for Common's implementation of
 * ObjectVersioningTest.
 * 
 * @see gov.va.med.esr.common.util.ObjectVersioningTest
 *  
 * Created Apr 18, 2007 4:21:21 PM
 * @author DNS   BOHMEG
 */
public class ObjectVersioningTest extends AbstractUITest {
 	
	private Class[] TARGET_CLASSES = { FinancialDetailsData.class };

	protected boolean serializeAllClasses = false; 

	private Class[] TARGET_CLASSES_NEEDING_SERIALIZING = {};

	private SystemParameterService systemParameterService;

	/**
	 * Standard test entry point
	 * @throws Exception
	 */
	public final void testVersioning() throws Exception {
		Class[] classesToSerialize = getClassesToSerialize();
		if(classesToSerialize != null && classesToSerialize.length > 0) {
			ObjectVersioningUtil.generateSerializedFiles(
					classesToSerialize, getESRVersion(), this);
		}
		ObjectVersioningUtil.deserializeFiles(getClassesToDeserialize());
	}
	
	/* Can be overriden by subclasses */
	protected Class[] getClassesToDeserialize() {
		return TARGET_CLASSES;
	}
	
	protected Class[] getClassesToSerialize() {
		if (serializeAllClasses)
			return getClassesToDeserialize();
		
		return TARGET_CLASSES_NEEDING_SERIALIZING;
	}
	
	
	/* These need to be public for reflection to find them */
	public FinancialDetailsData generateFinancialDetailsData() throws Exception {
		FinancialDetailsData data = new FinancialDetailsData();
		data.setAdjustedMedicalExpense("blah");
		return data;
	}

	public SystemParameterService getSystemParameterService() {
		return systemParameterService;
	}

	public void setSystemParameterService(
			SystemParameterService systemParameterService) {
		this.systemParameterService = systemParameterService;
	}
	
	private String getESRVersion() throws ServiceException {
		return this.systemParameterService.getEsrVersion();
	}	
}
