/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.util;

// Library Classes
import junit.framework.TestCase;

// ESR Classes
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.ui.common.util.DateUtils;

/**
 * @author Andrew Pach
 */
public class DateUtilsTests extends TestCase
{
    private static final String[] SAMPLE_DATES = new String[]{"02", "02/03", "2005", "02/2005",
        "10/01/2004", "10/1/2004", "3/1/2004", "3/11/2004", "10/01/2004 17:35"};

    public DateUtilsTests()
    {
        super();
    }

    public DateUtilsTests(String name)
    {
        super(name);
    }

    /**
     * Tests various imprecise date formats.
     */
    public void testImpreciseDates() throws Exception
    {
        for (int i = 0; i < SAMPLE_DATES.length; i++)
        {
            String dateString = (String)SAMPLE_DATES[i];
            System.out.println("**** item: " + dateString);
            ImpreciseDate date = DateUtils.getImpreciseDate(dateString, true, true);
            logImpreciseDate(date);
        }
    }

    private void logImpreciseDate(ImpreciseDate dt)
    {
        System.out.println("dt (" + (dt.isImprecise() ? "Imprecise" : "Precise") + ")");
        System.out.println("dt.getYear(): " + dt.getYear());
        System.out.println("dt.toString(): " + dt.toString());
        System.out.println("dt.getDate(): " + dt.getDate());
        System.out.println("dt.getString(): " + dt.getString());
        System.out.println("dt.toStandardFormat(): " + dt.toStandardFormat());
        System.out.println("dt.isTimePresent(): " + dt.isTimePresent());
        if (dt.isImprecise() && dt.getString() == null)
            fail("An ImpreciseDate that is imprecise needs a String value");
    }
}