/********************************************************************
 * Copyright  2005 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.util;

// ESR Classes
import gov.va.med.esr.common.util.AbstractCommonTestCase;

/**
 * Base class for JUnits that wish to load all beans.
 *
 * @author Andrew Pach
 * @version 1.0
 */
public abstract class AbstractUITest extends AbstractCommonTestCase
{
    // path in ui.jar
    protected static final String UI_CONTEXT = "ui/applicationContext.xml";

    // path in test_resource.jar
    protected static final String DEFAULT_TEST_CONTEXT = "spring/ui/test_components.xml";

    // allows subclasses to not have to name testcases
    public AbstractUITest()
    {
        super(new String[]{UI_CONTEXT, DEFAULT_TEST_CONTEXT});
    }

    // preserved for old code
    public AbstractUITest(String testName)
    {
        super(testName, new String[]{UI_CONTEXT, DEFAULT_TEST_CONTEXT});
    }
}