/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.militaryservice.action;

import java.util.Map;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.ApplicationConstants;
import gov.va.med.esr.ui.util.AbstractUITestCase;

/**
 * @author Madhu Katikala (@user)
 */
public class MilitaryServiceActionTest extends AbstractUITestCase {
    public MilitaryServiceActionTest(String testName) {
        super(testName);
    }

    public void testDisplay() {
        setConfigFile("militaryservice", "/WEB-INF/militaryservice/struts-config.xml");
        addRequestParameter("editedBy", "userA");
        setRequestPathInfo("/militaryservice", "/militaryservice");
        //loads person info from prevous session if applicable
        loadTestData();
        loadAppData();
        actionPerform();
        verifySessionData();
        verifyForward("success");
        verifyTilesForward("success",".view.militaryservice");
        verifyNoActionErrors();
        //saves the session data to be used in the next test case in seq test
        saveAppData();
    }
    protected void loadTestData () {
        //load the data from the database if the data is not available for the test        
        try {
            Person person = getSelectedPerson();
            Map appData = getAppData (); 
            //check whether we have in the app data
            if (person == null)
                person = (Person) appData.get(ApplicationConstants.SessionData.SELECTED_PERSON);

            if (person == null)
                person = getPerson(getPersonId());

/*
            appData.put(
                    ApplicationConstants.SessionData.SELECTED_PERSON_ID,
                    person.getEntityKey().getKeyValueAsString());              
*/
            appData.put(ApplicationConstants.SessionData.SELECTED_PERSON,
                    person);
            setAppData(appData);
        }catch (Exception e)
        {
            log.error("loadTestData failed ", e);
        }
    }
}
