/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.financials.action;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.ui.form.FinancialDetailsForm;
import gov.va.med.esr.ui.ApplicationConstants;
import gov.va.med.esr.ui.util.AbstractUITestCase;

import java.util.Map;

import org.apache.commons.lang.SerializationUtils;

import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/**
 * @author Madhu Katikala (@user)
 */
public class FinancialsActionTest extends AbstractUITestCase {
    public FinancialsActionTest(String testName) {
        super(testName);
    }
    
    public void testDisplay() {
        setConfigFile("financials", "/WEB-INF/financials/struts-config.xml");
        addRequestParameter("editedBy", "userA");
        setRequestPathInfo("/financials", "/financials");
        //loads person info from prevous session if applicable
        loadTestData();
        loadAppData();
        actionPerform();
        verifySessionData();
        verifyForward("success");
        verifyTilesForward("success",".view.financials");
        verifyNoActionErrors();
        //saves the session data to be used in the next test case in seq test
        saveAppData();
    }
    protected void loadTestData () {
        //load the data from the database if the data is not available for the test        
        try {
            Person person = getSelectedPerson();
            Map appData = getAppData (); 
            //check whether we have in the app data
            if (person == null)
                person = (Person) appData.get(ApplicationConstants.SessionData.SELECTED_PERSON);

            if (person == null)
                person = getPerson(getPersonId());

/*
            appData.put(
                    ApplicationConstants.SessionData.SELECTED_PERSON_ID,
                    person.getEntityKey().getKeyValueAsString());              
*/
            appData.put(ApplicationConstants.SessionData.SELECTED_PERSON,
                    person);
            setAppData(appData);
        }catch (Exception e)
        {
            log.error("loadTestData failed ", e);
        }
    }
    
    public void testInProcessSerialization() throws Exception {
        FinancialDetailsForm detailsForm = new FinancialDetailsForm();
        detailsForm.setAdjustedMedicalExpense("21323");
        detailsForm.setAskAdjudicationQuestion(true);
        detailsForm.setDepAmtContributed(1, "2000");
        
        byte[] data = SerializationUtils.serialize(detailsForm);
        String encoded  = new BASE64Encoder().encode(data);
        
        byte[] decoded = new BASE64Decoder().decodeBuffer(encoded);
        SerializationUtils.deserialize(decoded);
    }
}
