/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.ee.action;

import gov.va.med.esr.ui.util.AbstractUITestCase;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpSession;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionForm;

import servletunit.HttpServletRequestSimulator;
/**
 * @author Madhu Katikala (@user)
 */
public class EligibilityEditActionTest extends AbstractUITestCase {

	public EligibilityEditActionTest() {
		super();
	}

	public EligibilityEditActionTest(String name) {
		super(name);
	}
    
    public void testEligibilityEdit() {
        setConfigFile("ee", "/WEB-INF/ee/struts-config.xml");        
        addRequestParameter("methodName", "Edit");
        setRequestPathInfo("/ee","/gotoEligibilityEdit");
        //loads the applicatin data from the prevoius test case result
        loadAppData();
        actionPerform();
        verifySessionData();
        verifyForward("success");
        verifyTilesForward("success",".edit.eligibility");
        verifyNoActionErrors();
        //saves the application ot be passed on to the next test case
        saveAppData();
        try {
        	saveFormData(getSession(),"eligibilityForm");
        }catch (Exception e) {e.printStackTrace();}
    }
    
    public void testReviewImpact() {
        setConfigFile("ee", "/WEB-INF/ee/struts-config.xml");        
        addRequestParameter("methodName", "Review Impact");
        setRequestPathInfo("/ee","/eligibilityEdit");
        //loads the applicatin data from the prevoius test case result
        loadAppData();
        loadFormData("eligibilityForm",(HttpServletRequestSimulator)getRequest());
        actionPerform();
        verifySessionData();
        verifyForward("success");
        //verifyForward("failure");
        //verifyForward("addDisability");
        verifyForwardPath("/ee/eligibilityEditReview.display.do");
        verifyNoActionErrors();
        //saves the application ot be passed on to the next test case
        saveAppData();
    }
    
    protected static Map globalFormData = new HashMap ();
    
    //Use BeanUtils and save the properties in a map for the bean
    protected static void saveFormData (HttpSession session, String formBeanName) 
    throws Exception
    {
        ActionForm form = (ActionForm) session.getAttribute(formBeanName);

        Map formData = BeanUtils.describe(form);
        if (formData != null) {
            globalFormData.put(formBeanName,formData); 
        }      
    }
    //retrieve the bean properties and set on the request
    protected static void loadFormData (String formBeanName, HttpServletRequestSimulator request) 
    {    
        Map formData = (Map) globalFormData.get(formBeanName);
        if (formData == null || formData.size() == 0) return;
        Set keys = formData.keySet();
        Map allowedFormFields = getFormFields ();
        for (Iterator iter= keys.iterator(); iter.hasNext();)
        {            
            String key = (String) iter.next();
            //if the filed is not in the form skip (all struts related fields)
            if (!allowedFormFields.containsKey(key))
                continue;
            String defaultValue = (String) allowedFormFields.get(key);
            
            Object value = formData.get(key);
            if (value != null) {
            	System.out.println("Key: " + key + " class " + value.getClass().getName());
            	if (value.getClass().isArray()) {
                    System.out.println("array skipped");
                } else if (value instanceof String) {
                    String[] newValue = new String[1];
                    newValue[0] = (String)value;
                    request.addParameter(key,newValue);
                } else {
                    System.out.println("other skipped");
                }
            }
            else {
                log.info("Key:" + key + "value is null");                  
                request.addParameter(key,defaultValue);
                log.info("Setting default value "+ defaultValue + " for key " + key);                
            }
        }
    }
    
    //return the map of form fields for this form with default values null or ""
    private static Map formFields = null;
    private static Map getFormFields () {
    	if (formFields == null) 
            formFields = new HashMap ();
         formFields.put("deathDate","");
         formFields.put("birthDate","");
         formFields.put("todayDate","");
         formFields.put("enrollmentCategoryCode","");
         formFields.put("eligibilityStatus","");
         formFields.put("eligibilityStatusList",null);
         formFields.put("eligibilityStatusDate","");
         formFields.put("verificationMethod","");
         formFields.put("totalCheckAmount","");
         formFields.put("serviceConnected","");
         formFields.put("applicationDate","");
         formFields.put("isReceivingCompensation","");
         formFields.put("vaPension","");
         formFields.put("housebound","");
         formFields.put("aidAttendance","");
         formFields.put("purpleHeart","");
         formFields.put("phStatus","");
         formFields.put("phRejectRemark","");
         formFields.put("pow","");
         formFields.put("agentOrangeExposure","");
         formFields.put("agentOrangeLocation","");
         formFields.put("environmentalContaminationExposure","");
         formFields.put("radiationExposure","");
         formFields.put("radiationExposureMethod","");
         formFields.put("dischargeDueDisability","");
         formFields.put("disabilityRetirementStatus","");
         formFields.put("unemployable","");
         formFields.put("permanentTotal","");
         formFields.put("ratedIncompetent","");
         formFields.put("civilDate","");
         formFields.put("vaDate","");
         formFields.put("eligibleForMedicaid","");
         formFields.put("medicaidUpdatedDate","");
         formFields.put("ineligibleDate","");
         formFields.put("ineligibleReason","");
         formFields.put("ineligibleVARODecision","");
         formFields.put("claimFolderNumber","");
         formFields.put("claimFolderLocation","");
         formFields.put("preferredFacility","");
         formFields.put("canceledDeclinedIndicator","");
         formFields.put("canceledDeclinedEffectiveDate","");
         formFields.put("canceledDeclinedReason","");
         formFields.put("canceledDeclinedNotProcessedReason","");
         formFields.put("canceledDeclinedRemarks","");
         formFields.put("disabilityCodes","");
        //     private DisabilityBean[] disabilities;
         formFields.put(" percentage","");          
         return formFields;
    }
}
