/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.demographic.action;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.ui.ApplicationConstants;
import gov.va.med.esr.ui.util.AbstractUITestCase;

import java.util.Map;

/**
 * @author Madhu Katikala (@user)
 */
public class VeteranDemographicActionTest extends AbstractUITestCase {
  
    public VeteranDemographicActionTest(String testName) {
        super(testName);
    }

    public void testViewPageDisplay() {
        setConfigFile("demographic", "/WEB-INF/demographic/struts-config.xml");
        addRequestParameter("editedBy", "userA");
        setRequestPathInfo("/demographic", "/veterandemographic");
        //loads person info from prevous session if applicable
        loadTestData ();
        loadAppData();  //loads appdata from static data
        actionPerform();
        verifySessionData();
        verifyForward("success");
        verifyTilesForward("success",".view.demographic");
        verifyNoActionErrors();
        //saves the session data to be used in the next test case in seq test
        saveAppData();
    }
    protected void loadTestData () {
        //load the data from the database if the data is not available for the test        
        try {
            Person person = getSelectedPerson();
            Map appData = getAppData (); 
            //check whether we have in the app data
            if (person == null)
                person = (Person) appData.get(ApplicationConstants.SessionData.SELECTED_PERSON);

            if (person == null)
            	person = getPerson(getPersonId());

/*
            appData.put(
                    ApplicationConstants.SessionData.SELECTED_PERSON_ID,
                    person.getEntityKey().getKeyValueAsString());              
*/
            appData.put(ApplicationConstants.SessionData.SELECTED_PERSON,
                    person);
            setAppData(appData);
        }catch (Exception e)
        {
        	log.error("loadTestData failed ", e);
        }
    }
}
