/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.common.action;

// Library classes
import gov.va.med.esr.ui.util.AbstractUITestCase;

/**
 * Performs a unit test for a log on action
 */
public class LogonActionTest extends AbstractUITestCase {

   /**
    * Initializes the specific test case
    * @param name A test case name
    */
   public LogonActionTest(String name) {
      super(name);
   }

   public void testLogon() {
      log.info("Testing logon");
      addRequestParameter("userID", "weblogic");
      addRequestParameter("password", "weblogic");
      setRequestPathInfo("/logon");
      actionPerform();
      verifyForward("success");
      verifyForwardPath("/admin/search.display.do");
      //assertNotNull( getSession().getAttribute("appUser") );
      verifyNoActionErrors();
   }
   
   public void testSignout() {
      getSession(); //creates the session if it is not already there
      log.info("Testing signout");
      setRequestPathInfo("/signout");
      actionPerform();
      verifyForward("success");
      verifyTilesForward("success", ".logon.display");
      verifyNoActionErrors();
   }
}