/**
 * Created on 2:08:55 PM Jan 6, 2005 Project: UI
 * 
 * @author DNS   LEV
 */
package gov.va.med.esr.ui.admin.action;

//import servletunit.struts.CactusStrutsTestCase;
import gov.va.med.esr.ui.admin.beans.VeteranSearchBean;
import gov.va.med.esr.ui.util.AbstractUITestCase;

import java.util.List;

/**
 * Performs a unit test for a log on action
 */
public class SearchActionTest extends AbstractUITestCase {

	/**
	 * Initializes the specific test case
	 * 
	 * @param name
	 *            A test case name
	 */
	public SearchActionTest(String name) {
		super(name);
	}
/*
    public void testNoResult () {
        search("xyzabc",null);
    }
    */
    public void testValidResult () {
        search(getSearchFamilyName(),getSearchSSN());
    }
    /*
    public void testMultipleRecords () {
        search("TEST");
    }*/
    
	public void search(String familyName, String ssn) {
		setConfigFile("admin", "/WEB-INF/admin/struts-config.xml");
		setRequestPathInfo("/admin", "/search");

		//null values are not required set to specify the complete set
		addRequestParameter("ssn",ssn);
		addRequestParameter("givenName", (String) null);
		addRequestParameter("middleName", (String) null);
		addRequestParameter("familyName", familyName);
        
        log.info("Search Parameters : ssn " + ssn + " last name " + familyName);

		actionPerform();
		verifyForward("success");
		verifySessionData();
		verifyTilesForward("success", ".search.display");
		verifyNoActionErrors();
	}
    
	protected void verifySessionData() {
		super.verifySessionData();

		//get the from and the result list
		/*SearchActionForm form = (SearchActionForm) getSession().getAttribute(
				"searchActionForm");
        
        if (form == null) {
        	log.error("searchActionForm not found in the session");
        }*/
		List result = null;//form.getSearchResultList();
		if (result != null) {
            log.info("" + result.size() + " records found");
			for (int i = 0; i < result.size(); i++) {
				VeteranSearchBean searchResult = (VeteranSearchBean) result.get(i);
				log.info("Record: " + 
                        " SSN : " + searchResult.getSsn() + 
                        " Person Id: " + searchResult.getPersonID() + 
                        " Name: " + searchResult.getLastName() + "," + searchResult.getFirstName());
			}
		}else {
			log.info("No records found");
        }
	}
}