
package gov.va.med.esr.conversion;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.fw.conversion.BeanConverter;
import gov.va.med.fw.conversion.ConversionService;

import gov.va.med.esr.ui.util.AbstractUITestCase;

import gov.va.med.esr.conversion.FormTest;
import gov.va.med.esr.conversion.VOTest;

public class ConversionServiceTest extends AbstractUITestCase
{
	protected transient Log log = LogFactory.getLog(BeanConverter.class);
	
	public static void main(String[] args) 
	{
		junit.textui.TestRunner.run(ConversionService.class);
	}

	protected void setUp()
	throws Exception 
	{
		super.setUp();
		
	}
	
	public ConversionServiceTest(String arg0) 
	{
		super(arg0);
	}
	
	public void testConverter()
	{
		ConversionService conversionService = (ConversionService)ctx.getBean("conversionService");
		if(conversionService == null) 
		{
			log.trace("ConversionService is null");
			return;
		}
	
		FormTest form = new FormTest();
		form.setFirstName("Ranga");
		form.setMiddleName("K");
		form.setLastName("Muddaiah");
		form.setStreetName("13600 EDS Dr.");
		form.setCity("Herndon");
		String states[] = new String[3];
		states[0] = "va";
		states[1] = "md";
		states[2] = "dc";
		form.setStates(states);
		form.setZip("20191");
		form.setExt("1234");
		form.setBirthDate("05/24/2005");
		form.setAge("32");
		form.setUpdateDate("2005-05-24");
		List list = new ArrayList();
		list.add("list evement 1");
		list.add("list evement 2");
		list.add("list evement 3");
		String children[] = new String[3];
		children[0] = "one";
		children[1] = "two";
		children[2] = "three";
		form.setChildren(children);
		form.setList(list);
		try
		{
			System.out.println("The form data : " + form);
			VOTest vo = (VOTest)conversionService.convert(form,VOTest.class);
			System.out.println("The VO data : " + vo);
			
			System.out.println("vo.getAddress().getPostalCode().getZip() = " + ((vo != null) ? vo.getAddress().getPostalCode().getZip() : ""));
			
			FormTest newForm = new FormTest();
			conversionService.convert(vo,newForm);
			System.out.println("The newForm data : " + newForm);

		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}
}
