/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.workflow.action;

// Java classes
import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;

import gov.va.med.fw.ui.struts.AbstractForm;

/**
 * Form to store the user actions and selctions from work list
 * 
 * @author DNS   KATIKM
 * 
 */
public class WorklistForm extends AbstractForm {

	private static final long serialVersionUID = 4280428772657653153L;
    //Filter section
	private String vpid = null;
	private String lastName = null;
	private String ssn = null;
	private String itemNumber = null;
	private String itemType = null;
    private String createDateFrom;
    private String createDateTo;
    private String assignedDateFrom;
    private String assignedDateTo;    

	//Action header 
    private String assignTo = null;
    private String updateAction = null;
    private String returnLink = null;

    public WorklistForm() {
        super();
        clear();
    }

    public String getAssignTo() {
        return assignTo;
    }

    public String getUpdateAction() {
        return updateAction;
    }

    public void setAssignTo(String assignTo) {
        this.assignTo = assignTo;
    }

    public void setUpdateAction(String updateAction) {
        this.updateAction = updateAction;
    }

    public String getReturnLink() {
        return returnLink;
    }

    public void setReturnLink(String returnLink) {
        this.returnLink = returnLink;
    }

    public void reset(ActionMapping arg0, HttpServletRequest arg1) {
        super.reset(arg0, arg1);
        clear();
    }

	/**
	 * @return Returns the itemNumber.
	 */
	public String getItemNumber() {
		return this.itemNumber;
	}

	/**
	 * @param itemNumber The itemNumber to set.
	 */
	public void setItemNumber(String itemNumber) {
		this.itemNumber = itemNumber;
	}

	/**
	 * @return Returns the itemType.
	 */
	public String getItemType() {
		return this.itemType;
	}

	/**
	 * @param itemType The itemType to set.
	 */
	public void setItemType(String itemType) {
		this.itemType = itemType;
	}

	/**
	 * @return Returns the lastName.
	 */
	public String getLastName() {
		return this.lastName;
	}

	/**
	 * @param lastName The lastName to set.
	 */
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	/**
	 * @return Returns the ssn.
	 */
	public String getSsn() {
		return this.ssn;
	}

	/**
	 * @param ssn The ssn to set.
	 */
	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

	public String getAssignedDateFrom() {
		return this.assignedDateFrom;
	}

	public String getAssignedDateTo() {
		return this.assignedDateTo;
	}

	public String getCreateDateFrom() {
		return this.createDateFrom;
	}

	public String getCreateDateTo() {
		return this.createDateTo;
	}

	public void setAssignedDateFrom(String assignedDateFrom) {
		this.assignedDateFrom = assignedDateFrom;
	}

	public void setAssignedDateTo(String assignedDateTo) {
		this.assignedDateTo = assignedDateTo;
	}

	public void setCreateDateFrom(String createDateFrom) {
		this.createDateFrom = createDateFrom;
	}

	public void setCreateDateTo(String createDateTo) {
		this.createDateTo = createDateTo;
	}

	public String getVpid() {
		return this.vpid;
	}

	public void setVpid(String vpid) {
		this.vpid = vpid;
	}

	public void resetFilter() {
		vpid = null;
		lastName = null;
		ssn = null;
		itemNumber = null;
		itemType = null;
	    createDateFrom = null;
	    createDateTo = null;
	    assignedDateFrom = null;
	    assignedDateTo = null;    		
	}
	private void clear() {
        assignTo = null;
        updateAction = null;
        returnLink = null;        
    }
}
