/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.workflow.action;

import java.util.ArrayList;
import java.util.List;

import org.apache.struts.action.ActionForm;

import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.ui.valuelist.SelectableSearchValueListAdapter;
import gov.va.med.fw.ui.valuelist.ValueListException;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.esr.common.model.person.id.VPIDEntityKeyImpl;

import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.WorkflowSearchCriteria;

import gov.va.med.esr.ui.common.util.DateUtils;

public class WorkflowSearchValueListAdapter extends SelectableSearchValueListAdapter {

    private static final long serialVersionUID = 5159351847729993680L;
    
    private LookupService lookupService = null;

    public LookupService getLookupService() {
        return lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    /**
     * Performs a custom form to searchQueryInfo conversion to handle lookup data. It is assumed
     * that a valid state and form code exists on the passed in form.
     *
     * @param form The form that contains search parameters
     * @param searchQueryInfo The search query info object to populate with the search parameters.
     *
     * @throws ValueListException if there are any problems copying properties.
     */
    protected void populateFormAttributes(ActionForm form, SearchQueryInfo searchQueryInfo)
        throws ValueListException
    {
        // Typecase the parameters
        WorkflowSearchForm searchForm = (WorkflowSearchForm)form;
        WorkflowSearchCriteria searchCriteria = (WorkflowSearchCriteria)searchQueryInfo;

        // Convert the standard parameters
        searchCriteria.setAssignedDateFrom(DateUtils.getDate(searchForm.getAssignedDateFrom()));
        searchCriteria.setAssignedDateTo(DateUtils.getDate(searchForm.getAssignedDateTo()));
        searchCriteria.setAssignedTo(searchForm.getAssignedTo());
        searchCriteria.setCreateDateFrom(DateUtils.getDate(searchForm.getCreateDateFrom()));
        searchCriteria.setCreateDateTo(DateUtils.getDate(searchForm.getCreateDateTo()));
        searchCriteria.setFamilyName(searchForm.getFamilyName());
        searchCriteria.setGivenName(searchForm.getGivenName());
        searchCriteria.setSsn(searchForm.getSsn());
        searchCriteria.setAssignedItems(searchForm.isAssignedItems());
        searchCriteria.setUnassignedItems(searchForm.isUnassignedItems());
        searchCriteria.setPersonId(searchForm.getPersonId());
        searchCriteria.setOpenItems(searchForm.isOpenItems());
        searchCriteria.setItemNumber(searchForm.getItemNumber());
        if (StringUtils.isNotEmpty(searchForm.getVpid())) {
            try {
            String longVpid = VPIDEntityKeyImpl.getLongVPID(searchForm.getVpid());
        	List vpids = new ArrayList ();
        	   vpids.add(longVpid);
        	   searchCriteria.setVpids(vpids);
            }catch (Exception e){
                throw new ValueListException("Invalid VPID",e);
            }
        }
        try {
            if (StringUtils.isNotEmpty(searchForm.getFunctionalGroup())) {
                searchCriteria.setFunctionalGroup(
                    getLookupService().getFunctionalGroupByCode(
                            searchForm.getFunctionalGroup()));
            }
            if (StringUtils.isNotEmpty(searchForm.getItemStatus())) {
                searchCriteria.setItemStatus(
                    getLookupService().getWkfCaseStatusTypeByCode(searchForm.getItemStatus()));
            }
            if (StringUtils.isNotEmpty(searchForm.getItemType())) {
                searchCriteria.setItemType(
                    getLookupService().getWkfCaseTypeByCode(searchForm.getItemType()));
            }
            //populate reference lookup codes required
        }catch (Exception e) {
            throw new ValueListException("Invalid Lookup Code",e);
        }
    }    
}
