/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.ui.workflow.action;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionMapping;

import gov.va.med.fw.ui.struts.AbstractForm;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.esr.ui.common.beans.WorkflowSearchType;
import gov.va.med.esr.ui.common.beans.WorkflowSearchType.Code;

public class WorkflowSearchForm extends AbstractForm {

	private static final long serialVersionUID = -5174556445149833102L;
	
    private String emptyHiddenField;
	private String vpid;
	private String searchType;
    private String searchField;
    private String searchValue;
    private String functionalGroup;
    private String itemNumber;
    private String itemType;
    private String assignedTo;
    private String itemStatus;
    private String createDateFrom;
    private String createDateTo;
    private String assignedDateFrom;
    private String assignedDateTo;
    private String ssn;
    private String familyName;
    private String givenName;
    private String personId;
    private boolean assignedItems;
    private boolean unassignedItems;
    private boolean openItems;
    private boolean selectAll;
    
    public WorkflowSearchForm() {
        super();
        initialize();
    }

    public WorkflowSearchForm(WorklistForm form) {
        super();
        initialize();
        //copy the filter fields
        if (form != null) {
	        setFamilyName(form.getLastName());
	        setVpid(form.getVpid());
	        setSsn(form.getSsn());
	        setItemNumber(form.getItemNumber());
	        setItemType(form.getItemType());
	        setItemType(form.getItemType());
	        setCreateDateFrom(form.getCreateDateFrom());
	        setAssignedDateFrom(form.getAssignedDateFrom());
	        setCreateDateTo(form.getCreateDateTo());
	        setAssignedDateTo(form.getAssignedDateTo());	        
        }
    }
    
    public String getEmptyHiddenField() {
        return this.emptyHiddenField;
    }

    public void setEmptyHiddenField(String emptyHiddenField) {
        this.emptyHiddenField = emptyHiddenField;
    }

    public String getSearchType() {
        return searchType;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public String getSearchValue() {
        return searchValue;
    }

    public void setSearchValue(String searchValue) {
        this.searchValue = searchValue;
    }

    public String getAssignedDateFrom() {
        return assignedDateFrom;
    }

    public String getAssignedDateTo() {
        return assignedDateTo;
    }

    public String getAssignedTo() {
        return assignedTo;
    }

    public String getCreateDateFrom() {
        return createDateFrom;
    }

    public String getCreateDateTo() {
        return createDateTo;
    }

    public String getFamilyName() {
        return familyName;
    }

    public String getFunctionalGroup() {
        return functionalGroup;
    }

    public String getGivenName() {
        return givenName;
    }

    public String getItemType() {
        return itemType;
    }

    public String getSsn() {
        return ssn;
    }

    public String getItemStatus() {
        return itemStatus;
    }

    public void setAssignedDateFrom(String assignedDateFrom) {
        this.assignedDateFrom = assignedDateFrom;
    }

    public void setAssignedDateTo(String assignedDateTo) {
        this.assignedDateTo = assignedDateTo;
    }

    public void setAssignedTo(String assignedTo) {
        this.assignedTo = assignedTo;
    }

    public void setCreateDateFrom(String createDateFrom) {
        this.createDateFrom = createDateFrom;
    }

    public void setCreateDateTo(String createDateTo) {
        this.createDateTo = createDateTo;
    }

    public void setFamilyName(String familityName) {
        this.familyName = familityName;
    }

    public void setFunctionalGroup(String functionalGroup) {
        this.functionalGroup = functionalGroup;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public void setItemStatus(String status) {
        this.itemStatus = status;
    }
    
    /**
     * Returns true if search criterai is empty
     * @return
     */
    public boolean isEmpty() {
        if (StringUtils.isNotEmpty(searchField)||
        	StringUtils.isNotEmpty(functionalGroup) ||
            StringUtils.isNotEmpty(itemType) ||
            StringUtils.isNotEmpty(assignedTo) ||
            StringUtils.isNotEmpty(itemStatus) ||
            StringUtils.isNotEmpty(createDateFrom) ||
            StringUtils.isNotEmpty(createDateTo) ||
            StringUtils.isNotEmpty(assignedDateFrom) ||
            StringUtils.isNotEmpty(assignedDateTo) ||
            StringUtils.isNotEmpty(vpid) ||
            StringUtils.isNotEmpty(ssn) ||
            StringUtils.isNotEmpty(familyName) ||
            StringUtils.isNotEmpty(givenName)) {
            return false;
        }
        else {
            return true;
        }
    }
    
    public void reset(ActionMapping arg0, HttpServletRequest arg1) {
        super.reset(arg0, arg1);
        initialize();
    }
    
    public boolean isAssignedItems() {
        return assignedItems;
    }

    public boolean isUnassignedItems() {
        return unassignedItems;
    }

    public void setAssignedItems(boolean assignedItems) {
        this.assignedItems = assignedItems;
    }

    public void setUnassignedItems(boolean unassignedItems) {
        this.unassignedItems = unassignedItems;
    }

    public boolean isOpenItems() {
        return openItems;
    }

    public String getPersonId() {
        return personId;
    }

    public void setOpenItems(boolean openItems) {
        this.openItems = openItems;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

	public String getItemNumber() {
		return this.itemNumber;
	}

	public void setItemNumber(String itemNumber) {
		this.itemNumber = itemNumber;
	}

	public String getSearchField() {
		return this.searchField;
	}

	public void setSearchField(String searchField) {
		this.searchField = searchField;
	}

	public boolean isSelectAll() {
		return this.selectAll;
	}

	public void setSelectAll(boolean selectAll) {
		this.selectAll = selectAll;
	}

	public String getVpid() {
		return this.vpid;
	}

	public void setVpid(String vpid) {
		this.vpid = vpid;
	}

	private void initialize(){
        emptyHiddenField = null;
        searchType = null;
        searchField = null;
        searchValue = null;
        functionalGroup = null;
        itemType = null;
        assignedTo = null;
        itemStatus = null;
        createDateFrom = null;
        createDateTo = null;
        assignedDateFrom = null;
        assignedDateTo = null;
        ssn = null;
        familyName = null;
        givenName = null;
        personId = null;
        unassignedItems = false;
        assignedItems = false;
        openItems = true;
        itemNumber = null;
        selectAll = false;
        vpid = null;
    }
}
